/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.types;

import java.io.Serializable;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcMappedAttributeIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;

public class MethodWithArgs
implements DmcMappedAttributeIF,
Serializable {
    String returnType;
    String methodName;
    String argVector;
    String comment;

    public MethodWithArgs() {
        this.returnType = null;
        this.methodName = null;
        this.argVector = null;
        this.comment = null;
    }

    public MethodWithArgs(String rt, String mn, String av, String c) {
        this.returnType = rt;
        this.methodName = mn;
        this.argVector = av;
        this.comment = c;
    }

    public MethodWithArgs(MethodWithArgs mwa) {
        this.returnType = mwa.comment;
        this.methodName = mwa.methodName;
        this.argVector = mwa.argVector;
        this.comment = mwa.comment;
    }

    public MethodWithArgs(String v) throws DmcValueException {
        String value = v.trim();
        int spacepos = value.indexOf(" ");
        int lbpos = value.indexOf("(");
        if (lbpos == -1) {
            throw new DmcValueException("You must specify the argument vector, even if it's empty i.e ()");
        }
        int rbpos = value.indexOf(")", lbpos + 1);
        if (rbpos == -1) {
            throw new DmcValueException("Missing ) for the argument vector: " + v);
        }
        if (spacepos == -1) {
            throw new DmcValueException("Missing return type: " + v);
        }
        this.returnType = value.substring(0, spacepos);
        if (spacepos + 1 == lbpos) {
            throw new DmcValueException("Missing method name: " + v);
        }
        if (spacepos > lbpos) {
            throw new DmcValueException("Missing return type: " + v);
        }
        this.methodName = value.substring(spacepos + 1, lbpos).trim();
        if (this.methodName.length() == 0) {
            throw new DmcValueException("Missing method name: " + v);
        }
        this.argVector = value.substring(lbpos, rbpos + 1);
        this.comment = "";
        if (value.length() > rbpos + 1) {
            this.comment = value.substring(rbpos + 1).trim();
        }
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getArgVector() {
        return this.argVector;
    }

    public String getComment() {
        return this.comment;
    }

    public String getSignature() {
        return this.returnType + " " + this.methodName + this.argVector;
    }

    public String toString() {
        return this.returnType + " " + this.methodName + this.argVector + " " + this.comment;
    }

    public Object getKey() {
        return this.methodName;
    }

    public String getKeyAsString() {
        return this.methodName;
    }

    public boolean valuesAreEqual(DmcMappedAttributeIF obj) {
        boolean rc = false;
        if (obj instanceof MethodWithArgs) {
            MethodWithArgs other = (MethodWithArgs)obj;
            if (this.returnType.equals(other.returnType) && this.methodName.equals(other.methodName) && this.argVector.equals(other.argVector) && this.comment.equals(other.comment)) {
                rc = true;
            }
        }
        return rc;
    }

    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeUTF(this.returnType);
        dos.writeUTF(this.methodName);
        dos.writeUTF(this.argVector);
        dos.writeUTF(this.comment);
    }

    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        this.returnType = dis.readUTF();
        this.methodName = dis.readUTF();
        this.argVector = dis.readUTF();
        this.comment = dis.readUTF();
    }
}

