/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcMappedAttributeIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.CheapSplitter;
import org.dmd.mvw.tools.mvwgenerator.generated.enums.RequestOptionEnum;

public class RequestTypeWithOptions
implements DmcMappedAttributeIF,
Serializable {
    transient String requestImport;
    transient String responseImport;
    transient String classImport;
    transient boolean isOther;
    String requestType;
    String functionName;
    String className;
    HashSet<RequestOptionEnum> options;

    public RequestTypeWithOptions() {
        this.requestType = null;
        this.functionName = null;
        this.className = null;
        this.options = null;
    }

    public RequestTypeWithOptions(String rt, String fn, String cn, HashSet<RequestOptionEnum> o) {
        this.requestType = rt;
        this.functionName = fn;
        this.className = cn;
        this.options = o;
    }

    public RequestTypeWithOptions(RequestTypeWithOptions rtwo) {
        this.requestType = rtwo.requestType;
        this.functionName = rtwo.functionName;
        this.className = rtwo.className;
        this.options = rtwo.options;
    }

    public RequestTypeWithOptions(String v) throws DmcValueException {
        ArrayList tokens = CheapSplitter.split((String)v.replaceAll("\t", " ").trim(), (char)' ', (boolean)false, (boolean)true);
        if (tokens.size() < 2) {
            throw new DmcValueException("Too few tokens. Value should be of the form: <request type> <function name> [className] [DMPERRORS RPCERRORS CENTRALDMPERRORS CENTRALRPCERRORS  CENTRALERRORS]");
        }
        this.requestType = (String)tokens.get(0);
        if (this.requestType.endsWith("Request")) {
            int pos = this.requestType.indexOf("Request");
            this.requestType = this.requestType.substring(0, pos);
        }
        this.functionName = (String)tokens.get(1);
        int optionStart = 2;
        if (this.requestType.equals("Set") || this.requestType.equals("Create")) {
            optionStart = 3;
            if (tokens.size() < 3) {
                throw new DmcValueException("Too few tokens for a " + this.requestType + "Request. Value should be of the form: <request type> <function name> <className> [DMPERRORS RPCERRORS CENTRALDMPERRORS CENTRALRPCERRORS  CENTRALERRORS]");
            }
            this.className = (String)tokens.get(2);
            if (RequestOptionEnum.get(this.className) != null) {
                throw new DmcValueException("Missing class name for " + this.requestType + "Request. Value should be of the form: <request type> <function name> <className> [DMPERRORS RPCERRORS CENTRALDMPERRORS CENTRALRPCERRORS  CENTRALERRORS]");
            }
        }
        if (tokens.size() > optionStart) {
            this.options = new HashSet();
            for (int i = optionStart; i < tokens.size(); ++i) {
                RequestOptionEnum val = RequestOptionEnum.get((String)tokens.get(i));
                if (val == null) {
                    throw new DmcValueException((String)tokens.get(i) + " is not a valid option.");
                }
                if (!(val != RequestOptionEnum.CACHE && val != RequestOptionEnum.EVENTS || this.requestType.equals("Get"))) {
                    throw new DmcValueException("The " + (Object)((Object)val) + " option is only valid with GetRequests");
                }
                this.options.add(val);
            }
            if (this.options.size() == 1 && this.options.contains((Object)RequestOptionEnum.DMPERRORS)) {
                this.options.add(RequestOptionEnum.CENTRALRPCERRORS);
            } else if (this.options.size() == 1 && this.options.contains((Object)RequestOptionEnum.RPCERRORS)) {
                this.options.add(RequestOptionEnum.CENTRALDMPERRORS);
            }
        } else {
            this.options = new HashSet();
            this.options.add(RequestOptionEnum.DMPERRORS);
            this.options.add(RequestOptionEnum.CENTRALRPCERRORS);
        }
    }

    public boolean isOtherRequestType() {
        return this.isOther;
    }

    public boolean isUsingClassInfo() {
        return this.className != null;
    }

    public void setRequestImport(String ri) {
        if (!ri.contains(".dmp.")) {
            this.isOther = true;
        }
        this.requestImport = ri;
    }

    public void setClassImport(String ci) {
        this.classImport = ci;
    }

    public String getClassImport() {
        return this.classImport;
    }

    public String getRequestImport() {
        return this.requestImport;
    }

    public void setResponseImport(String ri) {
        this.responseImport = ri;
    }

    public String getResponseImport() {
        return this.responseImport;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getClassName() {
        return this.className;
    }

    public HashSet<RequestOptionEnum> getOptions() {
        return this.options;
    }

    public String toString() {
        if (this.options.size() == 0) {
            return this.requestType + " " + this.functionName;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.requestType + " " + this.functionName);
        Iterator<RequestOptionEnum> it = this.options.iterator();
        while (it.hasNext()) {
            sb.append(" " + (Object)((Object)it.next()));
        }
        return sb.toString();
    }

    public Object getKey() {
        return this.functionName;
    }

    public String getKeyAsString() {
        return this.functionName;
    }

    public boolean valuesAreEqual(DmcMappedAttributeIF obj) {
        boolean rc = false;
        if (obj instanceof RequestTypeWithOptions) {
            RequestTypeWithOptions other = (RequestTypeWithOptions)obj;
            if (this.requestType.equals(other.requestType) && this.functionName.equals(other.functionName) && this.options.equals(other.options)) {
                rc = true;
            }
        }
        return rc;
    }

    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeUTF(this.requestType);
        dos.writeUTF(this.functionName);
        dos.writeUTF(this.className);
        if (this.options.size() == 0) {
            dos.writeInt(0);
        } else {
            dos.writeInt(this.options.size());
            Iterator<RequestOptionEnum> it = this.options.iterator();
            while (it.hasNext()) {
                dos.writeInt(it.next().intValue());
            }
        }
    }

    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        this.requestType = dis.readUTF();
        this.functionName = dis.readUTF();
        this.className = dis.readUTF();
        this.options = new HashSet();
        int size = dis.readInt();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                int val = dis.readInt();
                this.options.add(RequestOptionEnum.get(val));
            }
        }
    }
}

