/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcMappedAttributeIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.mvw.tools.mvwgenerator.generated.enums.RequestOptionEnum;

public class RequestWithOptions
implements DmcMappedAttributeIF,
Serializable {
    String functionName;
    HashSet<RequestOptionEnum> options;

    public RequestWithOptions() {
        this.functionName = null;
        this.options = null;
    }

    public RequestWithOptions(String fn, HashSet<RequestOptionEnum> o) {
        this.functionName = fn;
        this.options = o;
    }

    public RequestWithOptions(RequestWithOptions gwm) {
        this.functionName = gwm.functionName;
        this.options = gwm.options;
    }

    public RequestWithOptions(String v) throws DmcValueException {
        String value = v.trim();
        int spacepos = value.indexOf(" ");
        if (spacepos == -1) {
            this.functionName = value;
            this.options = new HashSet();
            this.options.add(RequestOptionEnum.NONE);
        } else {
            this.functionName = value.substring(0, spacepos);
            this.options = new HashSet();
            String remainder = value.substring(spacepos + 1);
            String[] opts = remainder.split(" ");
            for (int i = 0; i < opts.length; ++i) {
                if (opts[i].length() <= 0) continue;
                RequestOptionEnum val = RequestOptionEnum.get(opts[i]);
                if (val == null) {
                    throw new DmcValueException(opts[i] + " is not a valid option.");
                }
                this.options.add(val);
            }
        }
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public HashSet<RequestOptionEnum> getOptions() {
        return this.options;
    }

    public String toString() {
        if (this.options.size() == 0) {
            return this.functionName;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.functionName);
        Iterator<RequestOptionEnum> it = this.options.iterator();
        while (it.hasNext()) {
            sb.append(" " + (Object)((Object)it.next()));
        }
        return sb.toString();
    }

    public Object getKey() {
        return this.functionName;
    }

    public String getKeyAsString() {
        return this.functionName;
    }

    public boolean valuesAreEqual(DmcMappedAttributeIF obj) {
        boolean rc = false;
        if (obj instanceof RequestWithOptions) {
            RequestWithOptions other = (RequestWithOptions)obj;
            if (this.functionName.equals(other.functionName) && this.options.equals(other.options)) {
                rc = true;
            }
        }
        return rc;
    }

    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeUTF(this.functionName);
        if (this.options.size() == 0) {
            dos.writeInt(0);
        } else {
            dos.writeInt(this.options.size());
            Iterator<RequestOptionEnum> it = this.options.iterator();
            while (it.hasNext()) {
                dos.writeInt(it.next().intValue());
            }
        }
    }

    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        this.functionName = dis.readUTF();
        this.options = new HashSet();
        int size = dis.readInt();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                int val = dis.readInt();
                this.options.add(RequestOptionEnum.get(val));
            }
        }
    }
}

