/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.dmd.dmc.types.CheapSplitter;
import org.dmd.mvw.tools.mvwgenerator.extended.Activity;
import org.dmd.mvw.tools.mvwgenerator.extended.RunContextItem;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.exceptions.DebugInfo;

public class ActivityFormatter {
    public static void formatActivity(String outdir, Activity activity) throws IOException {
        RunContextItem rci;
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(outdir, activity.getActivityName() + "BaseImpl.java");
        out.write("package " + activity.getDefinedInModule().getGenPackage() + ".generated.mvw.activities;\n\n");
        out.write(activity.getImports());
        out.write("\n");
        out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("abstract public class " + activity.getActivityName() + "BaseImpl" + activity.getBaseClassName() + activity.getInterfaces() + " {\n\n");
        boolean onDemand = false;
        Iterator iterator = activity.getUsesRunContextItemIterable().iterator();
        while (iterator.hasNext()) {
            rci = (RunContextItem)((Object)iterator.next());
            if (rci.isCreateOnDemand().booleanValue()) {
                onDemand = true;
                continue;
            }
            out.write(rci.getImplVariable());
        }
        if (onDemand) {
            out.write("\n");
            out.write("    protected final MvwRunContextIF runcontext;\n");
        }
        out.write("\n");
        out.write(activity.getCommsConstants());
        if (activity.usesRunContext()) {
            out.write("    public " + activity.getActivityName() + "BaseImpl(MvwRunContextIF rc){\n");
        } else {
            out.write("    public " + activity.getActivityName() + "BaseImpl(){\n");
        }
        iterator = activity.getUsesRunContextItemIterable().iterator();
        while (iterator.hasNext()) {
            rci = (RunContextItem)((Object)iterator.next());
            out.write(rci.getImplVariableAssignment());
        }
        if (activity.usesRunContext() && onDemand) {
            out.write("\n");
            out.write("        runcontext = rc;\n");
        }
        out.write(activity.getEventRegistration() + "\n");
        out.write("    }\n\n");
        iterator = activity.getUsesRunContextItemIterable().iterator();
        while (iterator.hasNext()) {
            rci = (RunContextItem)((Object)iterator.next());
            out.write(rci.getOnDemandMethod());
        }
        out.write(activity.getFireMethods());
        out.write(activity.getCommsMethods());
        out.write(activity.getAbstractMethods());
        out.write("}\n\n");
        out.close();
    }

    static void formatInitialActivity(String extendir, Activity activity) throws IOException {
        String fn;
        File file;
        File dir;
        StringBuilder outdir = new StringBuilder(extendir);
        if (activity.getSubpackage() != null) {
            ArrayList tokens = CheapSplitter.split((String)activity.getSubpackage(), (char)'.', (boolean)false, (boolean)true);
            for (String token : tokens) {
                outdir.append(File.separator + token);
            }
        }
        if (!(dir = new File(outdir.toString())).exists()) {
            DebugInfo.debug((String)("Creating extended code directory:" + outdir.toString()));
            dir.mkdirs();
        }
        if (!(file = new File(fn = outdir.toString() + File.separator + activity.getActivityName() + ".java")).exists()) {
            BufferedWriter out = new BufferedWriter(new FileWriter(fn));
            out.write("package " + activity.getExtendedClassPackage() + ";\n\n");
            out.write("import org.dmd.mvw.client.mvw.generated.mvw.MvwRunContextIF;\n");
            out.write("import " + activity.getBaseImplImport() + ";\n\n");
            out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("public class " + activity.getActivityName() + " extends " + activity.getActivityName() + "BaseImpl {\n\n");
            out.write("    public " + activity.getActivityName() + "(MvwRunContextIF rc){\n");
            out.write("        super(rc);\n");
            out.write("    }\n");
            out.write("}\n\n");
            out.write("\n");
            out.close();
        }
    }
}

