/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.dmd.dmc.types.CheapSplitter;
import org.dmd.mvw.tools.mvwgenerator.extended.Controller;
import org.dmd.mvw.tools.mvwgenerator.extended.RunContextItem;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.exceptions.DebugInfo;

public class ControllerFormatter {
    public static void formatControllerBaseImpl(String outdir, Controller controller) throws IOException {
        RunContextItem rci;
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(outdir, controller.getControllerName() + "BaseImpl.java");
        out.write("package " + controller.getDefinedInModule().getGenPackage() + ".generated.mvw.controllers;\n\n");
        out.write(controller.getImports());
        out.write("\n");
        out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("abstract public class " + controller.getControllerName() + "BaseImpl " + controller.getControllerInterfaces() + "{\n\n");
        boolean onDemand = false;
        Iterator iterator = controller.getUsesRunContextItemIterable().iterator();
        while (iterator.hasNext()) {
            rci = (RunContextItem)((Object)iterator.next());
            out.write(rci.getImplVariable());
            if (!rci.isCreateOnDemand().booleanValue()) continue;
            onDemand = true;
        }
        if (onDemand) {
            out.write("\n");
            out.write("    MvwRunContextIF runcontext;\n");
        }
        out.write("\n");
        out.write(controller.getCommsConstants());
        if (controller.getImplementsActionHasValue()) {
            out.write(controller.getActionVariables() + "\n");
        }
        if (controller.usesRunContext()) {
            out.write("    public " + controller.getControllerName() + "BaseImpl(MvwRunContextIF rc){\n");
        } else {
            out.write("    public " + controller.getControllerName() + "BaseImpl(){\n");
        }
        iterator = controller.getUsesRunContextItemIterable().iterator();
        while (iterator.hasNext()) {
            rci = (RunContextItem)((Object)iterator.next());
            out.write(rci.getImplVariableAssignment());
        }
        if (controller.usesRunContext() && onDemand) {
            out.write("\n");
            out.write("        runcontext = rc;\n");
        }
        out.write("\n" + controller.getAttributeSchemaLoaders() + "\n");
        out.write(controller.getEventRegistration() + "\n");
        if (controller.getImplementsActionHasValue()) {
            out.write(controller.getActionInstantiations() + "\n");
        }
        out.write("    }\n\n");
        iterator = controller.getUsesRunContextItemIterable().iterator();
        while (iterator.hasNext()) {
            rci = (RunContextItem)((Object)iterator.next());
            out.write(rci.getOnDemandMethod());
        }
        out.write(controller.getFireMethods());
        out.write(controller.getCommsMethods());
        out.write(controller.getAbstractMethods());
        out.write("}\n\n");
        out.close();
    }

    static void formatInitialController(String extendir, Controller controller) throws IOException {
        String fn;
        File file;
        File dir;
        StringBuilder outdir = new StringBuilder(extendir);
        if (controller.getSubpackage() != null) {
            ArrayList tokens = CheapSplitter.split((String)controller.getSubpackage(), (char)'.', (boolean)false, (boolean)true);
            for (String token : tokens) {
                outdir.append(File.separator + token);
            }
        }
        if (!(dir = new File(outdir.toString())).exists()) {
            DebugInfo.debug((String)("Creating extended code directory:" + outdir.toString()));
            dir.mkdirs();
        }
        if (!(file = new File(fn = outdir.toString() + File.separator + controller.getControllerName() + ".java")).exists()) {
            BufferedWriter out = new BufferedWriter(new FileWriter(fn));
            out.write("package " + controller.getExtendedClassPackage() + ";\n\n");
            out.write("import org.dmd.mvw.client.mvw.generated.mvw.MvwRunContextIF;\n");
            out.write("import " + controller.getBaseImplImport() + ";\n\n");
            out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("public class " + controller.getControllerName() + " extends " + controller.getControllerName() + "BaseImpl {\n\n");
            out.write("    public " + controller.getControllerName() + "(MvwRunContextIF rc){\n");
            out.write("        super(rc);\n");
            out.write("    }\n");
            out.write("}\n\n");
            out.write("\n");
            out.close();
        }
    }
}

