/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.util;

import java.io.IOException;
import java.util.Iterator;
import org.dmd.dms.ClassDefinition;
import org.dmd.mvw.tools.mvwgenerator.extended.forms.FormBindingDefinition;
import org.dmd.mvw.tools.mvwgenerator.types.EditField;
import org.dmd.mvw.tools.mvwgenerator.util.GenUtility;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.codegen.ImportManager;
import org.dmd.util.exceptions.DebugInfo;

public class FormBindingFormatter {
    public static void formatFormBinding(String outdir, FormBindingDefinition binding) throws IOException {
        EditField field;
        String genPackage = binding.getDefinedInModule().getGenPackage();
        String name = GenUtility.capTheName(binding.getBindingName().getNameString());
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(outdir, name + ".java");
        ImportManager imports = new ImportManager();
        imports.addImport("java.util.ArrayList", "To store the complete set of editors");
        imports.addImport("java.util.Iterator", "To access the complete set of editors");
        imports.addImport("org.dmd.dmc.presentation.DmcPresentationIF", "To access the complete set of editors");
        imports.addImport("org.dmd.dmc.DmcNamedObjectIF", "Used when testing if an object named");
        imports.addImport("org.dmd.dmc.DmcValueException", "Required if we have modification errors");
        imports.addImport("org.dmd.dmc.DmcValueExceptionSet", "Required if we have modification errors");
        imports.addImport("org.dmd.dms.generated.dmo.MetaDMSAG", "Required when edit object has no name");
        imports.addImport("org.dmd.dms.generated.types.DmcTypeModifierMV", "Required when edit object has no name");
        imports.addImport("org.dmd.mvw.client.mvwforms.base.MvwFormBindingIF", "Standard interface for bindings");
        imports.addImport("org.dmd.dmc.presentation.DmcPresentationTrackerIF", "Presentation tracker");
        Iterator iterator = binding.getEditFieldIterable().iterator();
        while (iterator.hasNext()) {
            EditField field2 = (EditField)iterator.next();
            imports.addImport(field2.getAttrDef().getAdapterClassImport(), "Adapter for " + field2.getAttribute());
            imports.addImport(field2.getEditorDef().getUseClass(), "Editor");
            imports.addImport(field2.getAttrDef().getDefinedIn().getDMSASGImport(), "Required schema");
        }
        ClassDefinition cd = binding.getEditObject();
        imports.addImport(cd.getDefinedIn().getSchemaPackage() + ".generated.dmo." + cd.getName() + "DMO", "For the object we're editting");
        out.write("package " + genPackage + ".generated.mvw.forms;\n\n");
        out.write(imports.getFormattedImports() + "\n");
        out.write("// " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("public class " + name + " implements MvwFormBindingIF {\n\n");
        out.write("    private " + cd.getName() + "DMO dmo;\n\n");
        out.write("    private Integer labelWidth;\n\n");
        out.write("    // If the object set on the binding doesn't have a name, it is considered a new object\n");
        out.write("    private boolean isNewObject;\n\n");
        out.write("    // The complete set of editors\n");
        out.write("    private ArrayList<DmcPresentationIF>\teditors;\n\n");
        out.write("    private DmcPresentationTrackerIF\ttracker;\n\n");
        Iterator iterator2 = binding.getEditFieldIterable().iterator();
        while (iterator2.hasNext()) {
            field = (EditField)iterator2.next();
            out.write(FormBindingFormatter.getDeclaration(field));
        }
        out.write("\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public " + name + "(){\n");
        out.write("\n");
        out.write("        isNewObject = false;\n\n");
        out.write("        editors = new ArrayList<>();\n\n");
        if (binding.getLabelWidth() != null) {
            out.write("        labelWidth = " + binding.getLabelWidth() + ";\n\n");
        }
        iterator2 = binding.getEditFieldIterable().iterator();
        while (iterator2.hasNext()) {
            field = (EditField)iterator2.next();
            out.write(FormBindingFormatter.getInstantiation(field));
        }
        out.write("    }\n\n");
        if (binding.getEditObject().getIsNamedBy() != null) {
            out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    public boolean isNewObject(){\n");
            out.write("        return(isNewObject);\n");
            out.write("    }\n\n");
        }
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public void setObject(" + cd.getName() + "DMO obj){\n");
        out.write("        dmo = obj;\n\n");
        if (binding.getEditObject().getIsNamedBy() != null) {
            out.write("        if (obj instanceof DmcNamedObjectIF){\n");
            out.write("            if (((DmcNamedObjectIF)obj).getObjectName() == null)\n");
            out.write("                isNewObject = true;\n");
            out.write("            else\n");
            out.write("                isNewObject = false;\n");
            out.write("        }\n");
        }
        iterator2 = binding.getEditFieldIterable().iterator();
        while (iterator2.hasNext()) {
            field = (EditField)iterator2.next();
            out.write(FormBindingFormatter.getSetDMO(field));
        }
        out.write("\n");
        iterator2 = binding.getEditFieldIterable().iterator();
        while (iterator2.hasNext()) {
            field = (EditField)iterator2.next();
            out.write(FormBindingFormatter.getSetAdapter(field));
        }
        out.write("\n");
        out.write("        tracker.reset();\n");
        out.write("    }\n\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public void setTracker(DmcPresentationTrackerIF t){\n");
        out.write("        tracker = t;\n");
        out.write("\n");
        iterator2 = binding.getEditFieldIterable().iterator();
        while (iterator2.hasNext()) {
            field = (EditField)iterator2.next();
            out.write(FormBindingFormatter.getSetTracker(field));
        }
        out.write("    }\n\n");
        out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public void setEnabledAll(boolean enabled){\n");
        iterator2 = binding.getEditFieldIterable().iterator();
        while (iterator2.hasNext()) {
            field = (EditField)iterator2.next();
            out.write(FormBindingFormatter.getSetEnabled(field));
        }
        out.write("    }\n\n");
        out.write("    public Iterator<DmcPresentationIF>    getEditors(){\n");
        out.write("        return(editors.iterator());\n");
        out.write("    }\n\n");
        out.write("    public Integer    getLabelWidth(){\n");
        out.write("        return(labelWidth);\n");
        out.write("    }\n\n");
        if (binding.getEditObject().getIsNamedBy() == null) {
            out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    public " + cd.getName() + "DMO getModifiedObject(){\n");
            out.write("        if (dmo == null)\n");
            out.write("            return(null);\n\n");
            out.write("        " + cd.getName() + "DMO modrec = (" + cd.getName() + "DMO) dmo.getNew();\n");
            out.write("        modrec.setModifier(new DmcTypeModifierMV(MetaDMSAG.__modify));\n");
            out.write("\n");
            out.write("        if (dmo instanceof DmcNamedObjectIF){\n");
            out.write("            DmcNamedObjectIF origObj\t= (DmcNamedObjectIF) dmo;\n");
            out.write("            try {\n");
            out.write("                modrec.set(origObj.getObjectNameAttribute().getAttributeInfo(), origObj.getObjectNameAttribute());\n");
            out.write("            } catch (DmcValueException e) {\n");
            out.write("                e.printStackTrace();\n");
            out.write("            }\n");
            out.write("        }\n\n");
            iterator2 = binding.getEditFieldIterable().iterator();
            while (iterator2.hasNext()) {
                field = (EditField)iterator2.next();
                out.write(FormBindingFormatter.getAddMods(field));
            }
            out.write("\n");
            out.write("        " + cd.getName() + "DMO rc = (" + cd.getName() + "DMO) dmo.cloneIt();\n");
            out.write("\n");
            out.write("        try {\n");
            out.write("            rc.applyModifier(modrec.getModifier());\n");
            out.write("        } catch(Exception ex){\n");
            out.write("            throw(new IllegalStateException(\"Shouldn't thrown an exception when modifying an object.\", ex));\n");
            out.write("        }\n");
            out.write("        \n");
            out.write("        return(rc);\n");
            out.write("    }\n\n");
        } else {
            out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    public " + cd.getName() + "DMO getModRec(){\n");
            out.write("        if (dmo == null)\n");
            out.write("            return(null);\n");
            out.write("\n");
            out.write("        if (isNewObject)\n");
            out.write("            throw(new IllegalStateException(\"You are dealing with a new object, call getModifiedObject(), not getModRec()\"));\n");
            out.write("\n");
            out.write("        " + cd.getName() + "DMO modrec = dmo.getModificationRecorder();\n");
            out.write("\n");
            iterator2 = binding.getEditFieldIterable().iterator();
            while (iterator2.hasNext()) {
                field = (EditField)iterator2.next();
                out.write(FormBindingFormatter.getAddMods(field));
            }
            out.write("\n");
            out.write("        return(modrec);\n");
            out.write("    }\n\n");
            out.write("    // " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    public " + cd.getName() + "DMO getModifiedObject(){\n");
            out.write("        if (dmo == null)\n");
            out.write("            return(null);\n");
            out.write("\n");
            out.write("        " + cd.getName() + "DMO modrec = (" + cd.getName() + "DMO) dmo.getNew();\n");
            out.write("        modrec.setModifier(new DmcTypeModifierMV(MetaDMSAG.__modify));\n\n");
            iterator2 = binding.getEditFieldIterable().iterator();
            while (iterator2.hasNext()) {
                field = (EditField)iterator2.next();
                out.write(FormBindingFormatter.getAddMods(field));
            }
            out.write("\n");
            out.write("        " + cd.getName() + "DMO rc = (" + cd.getName() + "DMO) dmo.cloneIt();\n");
            out.write("\n");
            out.write("        try {\n");
            out.write("            rc.applyModifier(modrec.getModifier());\n");
            out.write("        } catch(DmcValueExceptionSet ex){\n");
            out.write("            throw(new IllegalStateException(\"Your form should not permit invalid data\", ex));\n");
            out.write("        } catch(DmcValueException ex){\n");
            out.write("            throw(new IllegalStateException(\"Your form should not permit invalid data\", ex));\n");
            out.write("        }\n");
            out.write("        \n");
            out.write("        return(rc);\n");
            out.write("    }\n\n");
        }
        iterator2 = binding.getEditFieldIterable().iterator();
        while (iterator2.hasNext()) {
            field = (EditField)iterator2.next();
            out.write(FormBindingFormatter.getAccessMethod(field));
        }
        out.write("}\n\n");
        out.close();
    }

    static String getAccessMethod(EditField field) {
        StringBuffer sb = new StringBuffer();
        int lastpos = field.getEditorDef().getUseClass().lastIndexOf(".");
        String editor = field.getEditorDef().getUseClass().substring(lastpos + 1);
        String capped = GenUtility.capTheName(field.getAttribute());
        if (field.getAttrDef().getIndexSize() != null && !field.getEditorDef().isUseSingleEditor().booleanValue()) {
            for (int i = 0; i < field.getAttrDef().getIndexSize(); ++i) {
                sb.append("    public " + editor + " get" + capped + i + "(){\n");
                sb.append("        return(" + field.getAttribute() + i + ");\n");
                sb.append("    }\n");
                sb.append("\n");
            }
        } else {
            sb.append("    public " + editor + " get" + capped + "(){\n");
            sb.append("        return(" + field.getAttribute() + ");\n");
            sb.append("    }\n");
            sb.append("\n");
        }
        return sb.toString();
    }

    static String getAddMods(EditField field) {
        StringBuffer sb = new StringBuffer();
        if (field.getAttrDef().getIndexSize() != null && !field.getEditorDef().isUseSingleEditor().booleanValue()) {
            for (int i = 0; i < field.getAttrDef().getIndexSize(); ++i) {
                sb.append("        if (" + field.getAttribute() + "Adapter" + i + ".valueChanged())\n");
                sb.append("            " + field.getAttribute() + "Adapter" + i + ".addMods(modrec.getModifier());\n");
            }
        } else {
            sb.append("        if (" + field.getAttribute() + "Adapter.valueChanged())\n");
            sb.append("            " + field.getAttribute() + "Adapter.addMods(modrec.getModifier());\n");
        }
        return sb.toString();
    }

    static String getSetTracker(EditField field) {
        StringBuffer sb = new StringBuffer();
        if (field.getAttrDef().getIndexSize() != null && !field.getEditorDef().isUseSingleEditor().booleanValue()) {
            for (int i = 0; i < field.getAttrDef().getIndexSize(); ++i) {
                sb.append("        tracker.track(" + field.getAttribute() + i + ");\n");
            }
        } else {
            sb.append("        tracker.track(" + field.getAttribute() + ");\n");
        }
        return sb.toString();
    }

    static String getSetEnabled(EditField field) {
        if (field.getAttrDef().getIndexSize() != null && !field.getEditorDef().isUseSingleEditor().booleanValue()) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < field.getAttrDef().getIndexSize(); ++i) {
                sb.append("        " + field.getAttribute() + i + ".setEnabled(enabled);\n");
            }
            return sb.toString();
        }
        return "        " + field.getAttribute() + ".setEnabled(enabled);\n";
    }

    static String getSetAdapter(EditField field) {
        StringBuffer sb = new StringBuffer();
        String attr = field.getAttrDef().getDefinedIn().getDMSASGName() + ".__" + field.getAttribute();
        if (field.getAttrDef().getIndexSize() != null && !field.getEditorDef().isUseSingleEditor().booleanValue()) {
            for (int i = 0; i < field.getAttrDef().getIndexSize(); ++i) {
                sb.append("        " + field.getAttribute() + "Adapter" + i + ".setEmpty();\n");
                sb.append("        if (dmo == null)\n");
                sb.append("            " + field.getAttribute() + "Adapter" + i + ".setExisting(null);\n");
                sb.append("        else\n");
                sb.append("            " + field.getAttribute() + "Adapter" + i + ".setExisting(dmo.get(" + attr + "));\n");
                sb.append("        " + field.getAttribute() + i + ".setAdapter(" + field.getAttribute() + "Adapter" + i + ");\n");
                sb.append("\n");
            }
        } else {
            sb.append("        " + field.getAttribute() + "Adapter.setEmpty();\n");
            sb.append("        if (dmo == null)\n");
            sb.append("            " + field.getAttribute() + "Adapter.setExisting(null);\n");
            sb.append("        else\n");
            sb.append("            " + field.getAttribute() + "Adapter.setExisting(dmo.get(" + attr + "));\n");
            sb.append("        " + field.getAttribute() + ".setAdapter(" + field.getAttribute() + "Adapter);\n");
            sb.append("\n");
        }
        return sb.toString();
    }

    static String getDeclaration(EditField field) {
        StringBuffer sb = new StringBuffer();
        int lastpos = field.getEditorDef().getUseClass().lastIndexOf(".");
        String editor = field.getEditorDef().getUseClass().substring(lastpos + 1);
        if (field.getAttrDef().getIndexSize() != null && !field.getEditorDef().isUseSingleEditor().booleanValue()) {
            for (int i = 0; i < field.getAttrDef().getIndexSize(); ++i) {
                sb.append("    private " + editor + " " + field.getAttribute() + i + ";\n");
                sb.append("    private " + field.getAttrDef().getAdapterClassName() + " " + field.getAttribute() + "Adapter" + i + ";\n\n");
            }
        } else {
            sb.append("    private " + editor + " " + field.getAttribute() + ";\n");
            sb.append("    private " + field.getAttrDef().getAdapterClassName() + " " + field.getAttribute() + "Adapter;\n\n");
        }
        return sb.toString();
    }

    static String getInstantiation(EditField field) {
        StringBuffer sb = new StringBuffer();
        int lastpos = field.getEditorDef().getUseClass().lastIndexOf(".");
        String editor = field.getEditorDef().getUseClass().substring(lastpos + 1);
        if (field.getAttrDef().getIndexSize() != null && !field.getEditorDef().isUseSingleEditor().booleanValue()) {
            for (int i = 0; i < field.getAttrDef().getIndexSize(); ++i) {
                sb.append("        " + field.getAttribute() + i + " = new " + editor + "();\n");
                sb.append("        " + field.getAttribute() + i + ".setValueIndex(" + i + ");\n");
                sb.append("        " + field.getAttribute() + i + ".setLabel(\"" + field.getLabel() + "\");\n");
                if (field.isMandatory()) {
                    sb.append("        " + field.getAttribute() + i + ".setMandatory(true);\n");
                }
                if (field.isReadOnly()) {
                    sb.append("        " + field.getAttribute() + i + ".setReadOnly(true);\n");
                }
                if (field.getTip() != null) {
                    sb.append("        " + field.getAttribute() + i + ".setToolTip(\"" + field.getTip() + "\");\n");
                }
                String attr = field.getAttrDef().getDefinedIn().getDMSASGName() + ".__" + field.getAttribute();
                sb.append("        " + field.getAttribute() + "Adapter" + i + " = new " + field.getAttrDef().getAdapterClassName() + "(" + attr + ");\n");
                sb.append("        " + field.getAttribute() + i + ".setAdapter(" + field.getAttribute() + "Adapter" + i + ");\n");
                sb.append("        editors.add(" + field.getAttribute() + i + ");\n");
                sb.append("\n");
            }
        } else {
            sb.append("        " + field.getAttribute() + " = new " + editor + "();\n");
            sb.append("        " + field.getAttribute() + ".setLabel(\"" + field.getLabel() + "\");\n");
            if (field.isMandatory()) {
                sb.append("        " + field.getAttribute() + ".setMandatory(true);\n");
            }
            if (field.isReadOnly()) {
                sb.append("        " + field.getAttribute() + ".setReadOnly(true);\n");
            }
            if (field.getTip() != null) {
                sb.append("        " + field.getAttribute() + ".setToolTip(\"" + field.getTip() + "\");\n");
            }
            String attr = field.getAttrDef().getDefinedIn().getDMSASGName() + ".__" + field.getAttribute();
            sb.append("        " + field.getAttribute() + "Adapter = new " + field.getAttrDef().getAdapterClassName() + "(" + attr + ");\n");
            sb.append("        " + field.getAttribute() + ".setAdapter(" + field.getAttribute() + "Adapter);\n");
            sb.append("        editors.add(" + field.getAttribute() + ");\n");
            sb.append("\n");
        }
        return sb.toString();
    }

    static String getSetDMO(EditField field) {
        StringBuffer sb = new StringBuffer();
        if (field.getAttrDef().getIndexSize() != null && !field.getEditorDef().isUseSingleEditor().booleanValue()) {
            for (int i = 0; i < field.getAttrDef().getIndexSize(); ++i) {
                sb.append("        " + field.getAttribute() + i + ".setDMO(dmo);\n");
            }
        } else {
            sb.append("        " + field.getAttribute() + ".setDMO(dmo);\n");
        }
        return sb.toString();
    }
}

