/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.util;

import java.io.IOException;
import java.util.ArrayList;
import org.dmd.mvw.tools.mvwgenerator.extended.Event;
import org.dmd.mvw.tools.mvwgenerator.util.GenUtility;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.codegen.ImportManager;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.formatting.PrintfFormat;

public class GwtEventFormatter {
    static String args;
    static ArrayList<String> types;
    static ArrayList<String> members;
    static int longestType;

    public static void formatEvent(String outdir, Event event) throws IOException, ResultException {
        args = "()";
        types = new ArrayList();
        members = new ArrayList();
        longestType = 0;
        if (!event.needGwtEvent()) {
            return;
        }
        if (event.getArgVector() != null) {
            GwtEventFormatter.getMemberVariables(event.getArgVector(), event);
        }
        GwtEventFormatter.dumpEvent(outdir, event);
        GwtEventFormatter.dumpHandler(outdir, event);
    }

    static void getMemberVariables(String argVector, Event event) {
        if (argVector.equals("()")) {
            return;
        }
        types = event.getTypes();
        members = event.getMembers();
        longestType = event.getLongestType();
        StringBuffer av = new StringBuffer();
        for (int i = 0; i < types.size(); ++i) {
            int argcount = i + 1;
            if (i > 0) {
                av.append(", ");
            }
            av.append(types.get(i) + " arg" + argcount);
        }
        args = "(" + av.toString() + ")";
    }

    private static void dumpEvent(String outdir, Event event) throws IOException {
        String capped;
        String eventName = capped = GenUtility.capTheName(event.getEventName().getNameString());
        String handlerName = capped + "Handler";
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(outdir, eventName + ".java");
        int padding = longestType + 2;
        PrintfFormat format = new PrintfFormat("%-" + padding + "s");
        ImportManager.resetStatic();
        ImportManager.addImportStatic((String)"com.google.gwt.event.shared.GwtEvent", (String)"The base event type");
        if (event.getImportThisHasValue()) {
            for (String imp : event.getImportThisIterable()) {
                ImportManager.addImportStatic((String)imp, (String)"Required type");
            }
        }
        out.write("package " + event.getDefinedInModule().getGenPackage() + ".generated.mvw.events;\n\n");
        out.write(ImportManager.getFormattedImportsStatic() + "\n");
        out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("public class " + eventName + " extends GwtEvent<" + handlerName + "> {\n\n");
        if (types.size() > 0) {
            for (int i = 0; i < types.size(); ++i) {
                out.write("    " + format.sprintf(types.get(i)) + " " + members.get(i) + ";\n");
            }
            out.write("\n");
        }
        out.write("    public static Type<" + handlerName + "> TYPE = new Type<" + handlerName + ">();\n\n");
        out.write("    public " + eventName + args + " {\n");
        if (members.size() > 0) {
            for (int i = 0; i < members.size(); ++i) {
                int argcount = i + 1;
                out.write("        " + members.get(i) + " = arg" + argcount + ";\n");
            }
        }
        out.write("    }\n\n");
        if (members.size() > 0) {
            for (int i = 0; i < members.size(); ++i) {
                String upper = GenUtility.capTheName(members.get(i));
                out.write("    public " + types.get(i) + " get" + upper + "(){\n");
                out.write("        return(" + members.get(i) + ");\n");
                out.write("    }\n");
                out.write("\n");
            }
        }
        out.write("    @Override\n");
        out.write("    public Type<" + handlerName + "> getAssociatedType() {\n");
        out.write("        return TYPE;\n");
        out.write("    }\n\n");
        out.write("    @Override\n");
        out.write("    protected void dispatch(" + handlerName + " handler) {\n");
        out.write("        handler.handle" + capped + "(this);\n");
        out.write("    }\n\n");
        out.write("}\n");
        out.close();
    }

    private static void dumpHandler(String outdir, Event event) throws IOException {
        String capped;
        String eventName = capped = GenUtility.capTheName(event.getEventName().getNameString());
        String handlerName = capped + "Handler";
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(outdir, handlerName + ".java");
        ImportManager.resetStatic();
        ImportManager.addImportStatic((String)"com.google.gwt.event.shared.EventHandler", (String)"The marker interface");
        out.write("package " + event.getDefinedInModule().getGenPackage() + ".generated.mvw.events;\n\n");
        out.write(ImportManager.getFormattedImportsStatic() + "\n");
        out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("public interface " + handlerName + " extends EventHandler {\n\n");
        out.write("    void handle" + capped + "(" + eventName + " event);\n\n");
        out.write("}\n");
        out.close();
    }
}

