/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcNameClashObjectSet;
import org.dmd.dmc.DmcNameClashResolverIF;
import org.dmd.dmc.DmcNameResolverWithClashSupportIF;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcOmni;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.types.CamelCaseName;
import org.dmd.dmp.server.generated.DmpSchemaAG;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.EnumDefinition;
import org.dmd.dms.SchemaDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.types.EnumValue;
import org.dmd.dms.util.DmsSchemaParser;
import org.dmd.mvw.tools.mvwgenerator.extended.Activity;
import org.dmd.mvw.tools.mvwgenerator.extended.Component;
import org.dmd.mvw.tools.mvwgenerator.extended.Controller;
import org.dmd.mvw.tools.mvwgenerator.extended.EnumMappingGenerator;
import org.dmd.mvw.tools.mvwgenerator.extended.Event;
import org.dmd.mvw.tools.mvwgenerator.extended.I18NConfig;
import org.dmd.mvw.tools.mvwgenerator.extended.Module;
import org.dmd.mvw.tools.mvwgenerator.extended.MvwDefinition;
import org.dmd.mvw.tools.mvwgenerator.extended.Place;
import org.dmd.mvw.tools.mvwgenerator.extended.Presenter;
import org.dmd.mvw.tools.mvwgenerator.extended.PropertyAccess;
import org.dmd.mvw.tools.mvwgenerator.extended.PropertyAccessGenerator;
import org.dmd.mvw.tools.mvwgenerator.extended.RunContextItem;
import org.dmd.mvw.tools.mvwgenerator.extended.SubPlace;
import org.dmd.mvw.tools.mvwgenerator.extended.View;
import org.dmd.mvw.tools.mvwgenerator.extended.WebApplication;
import org.dmd.mvw.tools.mvwgenerator.extended.forms.EnumMapping;
import org.dmd.mvw.tools.mvwgenerator.extended.forms.FieldEditorDefinition;
import org.dmd.mvw.tools.mvwgenerator.extended.forms.FormBindingDefinition;
import org.dmd.mvw.tools.mvwgenerator.extended.menus.ActionBinding;
import org.dmd.mvw.tools.mvwgenerator.extended.menus.Menu;
import org.dmd.mvw.tools.mvwgenerator.extended.menus.MenuBar;
import org.dmd.mvw.tools.mvwgenerator.extended.menus.MenuImplementationConfig;
import org.dmd.mvw.tools.mvwgenerator.extended.menus.MenuItem;
import org.dmd.mvw.tools.mvwgenerator.extended.menus.Separator;
import org.dmd.mvw.tools.mvwgenerator.extended.menus.SubMenu;
import org.dmd.mvw.tools.mvwgenerator.generated.dmo.ModuleDMO;
import org.dmd.mvw.tools.mvwgenerator.generated.dmw.MenuElementDefinitionDMW;
import org.dmd.mvw.tools.mvwgenerator.types.EditField;
import org.dmd.mvw.tools.mvwgenerator.types.RequestTypeWithOptions;
import org.dmd.mvw.tools.mvwgenerator.util.RunContextItemCollection;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;

public class MvwDefinitionManager
implements DmcNameClashResolverIF,
DmcNameResolverWithClashSupportIF {
    SchemaManager schema;
    SchemaManager readSchemas;
    DmsSchemaParser schemaParser;
    TreeMap<CamelCaseName, MvwDefinition> allDefs;
    Module codeGenModule;
    WebApplication application;
    Module currentModule;
    TreeMap<CamelCaseName, Module> modules;
    TreeMap<CamelCaseName, Event> events;
    TreeMap<CamelCaseName, Controller> controllers;
    TreeMap<CamelCaseName, Presenter> presenters;
    TreeMap<CamelCaseName, Activity> activities;
    TreeMap<CamelCaseName, Component> components;
    TreeMap<CamelCaseName, Place> places;
    TreeMap<CamelCaseName, SubPlace> subPlaces;
    TreeMap<CamelCaseName, View> views;
    TreeMap<CamelCaseName, EnumMappingGenerator> enumGenerators;
    TreeMap<CamelCaseName, PropertyAccessGenerator> propertyAccessGenerators;
    Controller centralRpcErrorHandler;
    Controller centralDmpErrorHandler;
    Controller centralAsyncErrorHandler;
    RunContextItem centralAsyncErrorHandlerRCI;
    TreeMap<String, RunContextItemCollection> contexts;
    RunContextItemCollection defaultContext;
    final String controllerSubpackage = "controllers";
    final String presenterSubpackage = "presenters";
    final String viewSubpackage = "views";
    final String activitySubpackage = "activities";
    MenuImplementationConfig menuImplementation;
    RunContextItem menuFactoryRCI;
    TreeMap<CamelCaseName, MenuElementDefinitionDMW> menuElements;
    TreeMap<CamelCaseName, MenuBar> menuBars;
    TreeMap<CamelCaseName, SubMenu> subMenus;
    TreeMap<CamelCaseName, MenuItem> menuItems;
    TreeMap<CamelCaseName, Separator> separators;
    TreeMap<CamelCaseName, ActionBinding> actions;
    TreeMap<CamelCaseName, FieldEditorDefinition> fieldEditors;
    TreeMap<CamelCaseName, FormBindingDefinition> formBindings;
    TreeMap<CamelCaseName, EnumMapping> enumMappings;
    TreeMap<CamelCaseName, PropertyAccess> propertyAccessDefs;
    boolean needMvwComms;
    CamelCaseName key;
    private boolean debug;
    private boolean schemadebug;

    public MvwDefinitionManager(SchemaManager s, DmsSchemaParser sp) throws ResultException, DmcValueException, DmcNameClashException {
        this.schema = s;
        this.schemaParser = sp;
        this.key = new CamelCaseName();
        this.init();
    }

    public void debug(boolean flag) {
        this.debug = flag;
    }

    public void schemadebug(boolean flag) {
        this.schemadebug = flag;
    }

    void init() throws ResultException, DmcValueException, DmcNameClashException {
        this.allDefs = new TreeMap();
        this.modules = new TreeMap();
        this.views = new TreeMap();
        this.events = new TreeMap();
        this.controllers = new TreeMap();
        this.presenters = new TreeMap();
        this.activities = new TreeMap();
        this.components = new TreeMap();
        this.places = new TreeMap();
        this.subPlaces = new TreeMap();
        this.enumGenerators = new TreeMap();
        this.propertyAccessGenerators = new TreeMap();
        this.contexts = new TreeMap();
        this.defaultContext = new RunContextItemCollection("Default");
        this.contexts.put("Default", this.defaultContext);
        this.readSchemas = new SchemaManager();
        this.codeGenModule = null;
        this.application = null;
        this.needMvwComms = false;
        this.centralDmpErrorHandler = null;
        this.centralRpcErrorHandler = null;
        this.menuImplementation = null;
        this.menuFactoryRCI = null;
        this.menuElements = new TreeMap();
        this.menuBars = new TreeMap();
        this.subMenus = new TreeMap();
        this.menuItems = new TreeMap();
        this.separators = new TreeMap();
        this.actions = new TreeMap();
        this.fieldEditors = new TreeMap();
        this.formBindings = new TreeMap();
        this.enumMappings = new TreeMap();
        this.propertyAccessDefs = new TreeMap();
    }

    public ArrayList<Component> centralDmpErrorHandlingOK() {
        ArrayList<Component> needCentral = new ArrayList<Component>();
        for (Component component : this.components.values()) {
            if (!component.usesCentralDmpErrorHandling()) continue;
            needCentral.add(component);
        }
        if (needCentral.size() == 0) {
            needCentral = null;
        } else if (this.centralDmpErrorHandler != null) {
            needCentral = null;
        }
        return needCentral;
    }

    public ArrayList<Component> centralRpcErrorHandlingOK() {
        ArrayList<Component> needCentral = new ArrayList<Component>();
        for (Component component : this.components.values()) {
            if (!component.usesCentralRpcErrorHandling()) continue;
            needCentral.add(component);
        }
        if (needCentral.size() == 0) {
            needCentral = null;
        } else if (this.centralRpcErrorHandler != null) {
            needCentral = null;
        }
        return needCentral;
    }

    public TreeMap<CamelCaseName, MenuBar> getMenuBars() {
        return this.menuBars;
    }

    public TreeMap<CamelCaseName, SubMenu> getSubMenus() {
        return this.subMenus;
    }

    public TreeMap<CamelCaseName, MenuItem> getMenuItems() {
        return this.menuItems;
    }

    public TreeMap<CamelCaseName, Separator> getSeparators() {
        return this.separators;
    }

    public TreeMap<CamelCaseName, FormBindingDefinition> getFormBindings() {
        return this.formBindings;
    }

    public TreeMap<CamelCaseName, EnumMapping> getEnumMappings() {
        return this.enumMappings;
    }

    public TreeMap<CamelCaseName, PropertyAccess> getPropertyAccessDefs() {
        return this.propertyAccessDefs;
    }

    public void reset() throws ResultException, DmcValueException, DmcNameClashException {
        this.init();
    }

    public Module getCodeGenModule() {
        return this.codeGenModule;
    }

    public RunContextItemCollection getDefaultContext() {
        return this.defaultContext;
    }

    public MenuImplementationConfig getMenuImplementation() {
        return this.menuImplementation;
    }

    public WebApplication getApplication() {
        return this.application;
    }

    public Module getModule(String cn) throws DmcValueException {
        this.key.setNameString(cn);
        return this.modules.get(this.key);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addDefinition(MvwDefinition def) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        block46: {
            Iterator<String> it;
            block50: {
                block71: {
                    block70: {
                        block69: {
                            block68: {
                                RunContextItem rci;
                                block67: {
                                    block66: {
                                        block65: {
                                            block64: {
                                                Menu menu;
                                                block63: {
                                                    block62: {
                                                        block61: {
                                                            block60: {
                                                                block59: {
                                                                    block58: {
                                                                        block57: {
                                                                            block56: {
                                                                                block55: {
                                                                                    block54: {
                                                                                        block53: {
                                                                                            block52: {
                                                                                                ResultException ex;
                                                                                                block51: {
                                                                                                    block49: {
                                                                                                        this.checkAndAdd(def, this.allDefs);
                                                                                                        this.setSubpackage(def);
                                                                                                        if (!(def instanceof Module)) break block49;
                                                                                                        Module mod = (Module)def;
                                                                                                        ModuleDMO dmo = mod.getDMO();
                                                                                                        this.modules.put(def.getCamelCaseName(), mod);
                                                                                                        if (this.codeGenModule == null) {
                                                                                                            this.codeGenModule = mod;
                                                                                                        }
                                                                                                        this.currentModule = mod;
                                                                                                        if (!mod.getDependsOnSchemaHasValue()) break block46;
                                                                                                        it = dmo.getDependsOnSchema();
                                                                                                        break block50;
                                                                                                    }
                                                                                                    if (!(def instanceof WebApplication)) break block51;
                                                                                                    WebApplication app = (WebApplication)def;
                                                                                                    if (app.getDefinedInModule() == this.codeGenModule) {
                                                                                                        this.application = app;
                                                                                                        RunContextItem rci2 = new RunContextItem();
                                                                                                        rci2.setAutoCreated(true);
                                                                                                        RunContextItemCollection rcic = this.contexts.get(rci2.getContextImpl());
                                                                                                        rci2.setItemName("historyMapper");
                                                                                                        rci2.addDescription("This is the auto generated run context item that provides a handle to the application specific PlaceHistoryMapper for a web application.");
                                                                                                        rci2.setItemOrder(7);
                                                                                                        rci2.setUseClass(this.codeGenModule.getGenPackage() + ".generated.mvw.places." + app.getAppName() + "PlaceHistoryMapper");
                                                                                                        rci2.setConstruction("GWT.create(" + app.getAppName() + "PlaceHistoryMapper.class)");
                                                                                                        rci2.addImportThis("com.google.gwt.core.client.GWT");
                                                                                                        rci2.setDefinedInModule(app.getDefinedInModule());
                                                                                                        if (rcic == null) {
                                                                                                            rcic = new RunContextItemCollection(rci2.getContextImpl());
                                                                                                            this.contexts.put(rci2.getContextImpl(), rcic);
                                                                                                        }
                                                                                                        rcic.addItem(rci2);
                                                                                                        rci2.getDefinedInModule().addRunContextItem(rci2);
                                                                                                    }
                                                                                                    break block46;
                                                                                                }
                                                                                                if (!(def instanceof Controller)) break block52;
                                                                                                Controller controller = (Controller)def;
                                                                                                this.controllers.put(def.getCamelCaseName(), controller);
                                                                                                this.components.put(def.getCamelCaseName(), controller);
                                                                                                RunContextItem controllerRCI = null;
                                                                                                if (controller.isAddedToRunContext().booleanValue()) {
                                                                                                    controllerRCI = new RunContextItem();
                                                                                                    controllerRCI.setAutoCreated(true);
                                                                                                    RunContextItemCollection rcic = this.contexts.get(controllerRCI.getContextImpl());
                                                                                                    controllerRCI.setItemName(controller.getControllerName().getNameString() + "RCI");
                                                                                                    controllerRCI.addDescription("The auto generated run context item for the " + controller.getControllerName());
                                                                                                    if (controller.getSubpackage() == null) {
                                                                                                        controllerRCI.setUseClass(this.currentModule.getGenPackage() + ".extended." + controller.getControllerName());
                                                                                                    } else {
                                                                                                        controllerRCI.setUseClass(this.currentModule.getGenPackage() + ".extended." + controller.getSubpackage() + "." + controller.getControllerName());
                                                                                                    }
                                                                                                    if (controller.usesRunContext()) {
                                                                                                        controllerRCI.setConstruction("new " + controller.getControllerName() + "(this)");
                                                                                                    } else {
                                                                                                        controllerRCI.setConstruction("new " + controller.getControllerName() + "()");
                                                                                                    }
                                                                                                    controllerRCI.setDefinedInModule(controller.getDefinedInModule());
                                                                                                    if (controller.getItemOrder() != null) {
                                                                                                        controllerRCI.setItemOrder(controller.getItemOrder());
                                                                                                    }
                                                                                                    if (rcic == null) {
                                                                                                        rcic = new RunContextItemCollection(controllerRCI.getContextImpl());
                                                                                                        this.contexts.put(controllerRCI.getContextImpl(), rcic);
                                                                                                    }
                                                                                                    rcic.addItem(controllerRCI);
                                                                                                    controllerRCI.getDefinedInModule().addRunContextItem(controllerRCI);
                                                                                                    controller.setRunContextItem(controllerRCI);
                                                                                                    controllerRCI.setCamelCaseName(controllerRCI.getObjectName());
                                                                                                    this.checkAndAdd(controllerRCI, this.allDefs);
                                                                                                }
                                                                                                if (controller.isCentralRPCErrorHandler().booleanValue()) {
                                                                                                    if (this.centralRpcErrorHandler != null) {
                                                                                                        if (!controller.getControllerName().equals((Object)this.centralRpcErrorHandler.getControllerName())) {
                                                                                                            ex = new ResultException();
                                                                                                            ex.addError("Multiple controllers are specified as the central RPC error handler.");
                                                                                                            ex.result.lastResult().moreMessages(this.centralRpcErrorHandler.getControllerName() + " in " + this.centralRpcErrorHandler.getDefinedInModule().getFile() + " at line " + this.centralRpcErrorHandler.getDefinedInModule().getLineNumber());
                                                                                                            ex.result.lastResult().moreMessages(controller.getControllerName() + " in " + controller.getDefinedInModule().getFile() + " at line " + controller.getDefinedInModule().getLineNumber());
                                                                                                            throw ex;
                                                                                                        }
                                                                                                    } else {
                                                                                                        this.centralRpcErrorHandler = controller;
                                                                                                    }
                                                                                                }
                                                                                                if (controller.isCentralDMPErrorHandler().booleanValue()) {
                                                                                                    if (this.centralDmpErrorHandler != null) {
                                                                                                        if (!controller.getControllerName().equals((Object)this.centralDmpErrorHandler.getControllerName())) {
                                                                                                            ex = new ResultException();
                                                                                                            ex.addError("Multiple controllers are specified as the central DMP error handler.");
                                                                                                            ex.result.lastResult().moreMessages(this.centralDmpErrorHandler.getControllerName() + " in " + this.centralDmpErrorHandler.getDefinedInModule().getFile() + " at line " + this.centralDmpErrorHandler.getDefinedInModule().getLineNumber());
                                                                                                            ex.result.lastResult().moreMessages(controller.getControllerName() + " in " + controller.getDefinedInModule().getFile() + " at line " + controller.getDefinedInModule().getLineNumber());
                                                                                                            throw ex;
                                                                                                        }
                                                                                                    } else {
                                                                                                        this.centralDmpErrorHandler = controller;
                                                                                                    }
                                                                                                }
                                                                                                if (controller.isCentralAsyncErrorHandler().booleanValue()) {
                                                                                                    if (this.centralAsyncErrorHandler != null) {
                                                                                                        if (!controller.getControllerName().equals((Object)this.centralAsyncErrorHandler.getControllerName())) {
                                                                                                            ex = new ResultException();
                                                                                                            ex.addError("Multiple controllers are specified as the central asynchronous code loading error handler.");
                                                                                                            ex.result.lastResult().moreMessages(this.centralAsyncErrorHandler.getControllerName() + " in " + this.centralAsyncErrorHandler.getDefinedInModule().getFile() + " at line " + this.centralAsyncErrorHandler.getDefinedInModule().getLineNumber());
                                                                                                            ex.result.lastResult().moreMessages(controller.getControllerName() + " in " + controller.getDefinedInModule().getFile() + " at line " + controller.getDefinedInModule().getLineNumber());
                                                                                                            throw ex;
                                                                                                        }
                                                                                                        break block46;
                                                                                                    } else {
                                                                                                        this.centralAsyncErrorHandler = controller;
                                                                                                        this.centralAsyncErrorHandlerRCI = controllerRCI;
                                                                                                    }
                                                                                                }
                                                                                                break block46;
                                                                                            }
                                                                                            if (!(def instanceof Presenter)) break block53;
                                                                                            Presenter presenter = (Presenter)def;
                                                                                            this.presenters.put(def.getCamelCaseName(), presenter);
                                                                                            this.components.put(def.getCamelCaseName(), presenter);
                                                                                            RunContextItem rci3 = new RunContextItem();
                                                                                            rci3.setAutoCreated(true);
                                                                                            RunContextItemCollection rcic = this.contexts.get(rci3.getContextImpl());
                                                                                            rci3.setItemName(presenter.getPresenterName().getNameString() + "RCI");
                                                                                            rci3.addDescription("The auto generated run context item for the " + presenter.getPresenterName());
                                                                                            if (presenter.getSubpackage() == null) {
                                                                                                rci3.setUseClass(this.currentModule.getGenPackage() + ".extended." + presenter.getPresenterName());
                                                                                            } else {
                                                                                                rci3.setUseClass(this.currentModule.getGenPackage() + ".extended." + presenter.getSubpackage() + "." + presenter.getPresenterName());
                                                                                            }
                                                                                            if (presenter.usesRunContext()) {
                                                                                                if (presenter.isCodeSplit().booleanValue()) {
                                                                                                    rci3.setConstruction("new " + presenter.getPresenterName() + "(thisContext)");
                                                                                                } else {
                                                                                                    rci3.setConstruction("new " + presenter.getPresenterName() + "(this)");
                                                                                                }
                                                                                            } else {
                                                                                                rci3.setConstruction("new " + presenter.getPresenterName() + "()");
                                                                                            }
                                                                                            rci3.setDefinedInModule(presenter.getDefinedInModule());
                                                                                            rci3.setPresenter(presenter);
                                                                                            if (rcic == null) {
                                                                                                rcic = new RunContextItemCollection(rci3.getContextImpl());
                                                                                                this.contexts.put(rci3.getContextImpl(), rcic);
                                                                                            }
                                                                                            rcic.addItem(rci3);
                                                                                            rci3.getDefinedInModule().addRunContextItem(rci3);
                                                                                            rci3.setCreateOnDemand(true);
                                                                                            rci3.setSingleton(presenter.isSingleton());
                                                                                            presenter.setRunContextItem(rci3);
                                                                                            this.allDefs.put(rci3.getItemName(), rci3);
                                                                                            break block46;
                                                                                        }
                                                                                        if (!(def instanceof Activity)) break block54;
                                                                                        Activity activity = (Activity)def;
                                                                                        this.activities.put(def.getCamelCaseName(), activity);
                                                                                        this.components.put(def.getCamelCaseName(), activity);
                                                                                        break block46;
                                                                                    }
                                                                                    if (!(def instanceof View)) break block55;
                                                                                    View view = (View)def;
                                                                                    this.views.put(def.getCamelCaseName(), view);
                                                                                    if (view.requiresEventBus()) {
                                                                                        view.getDMO().addUsesRunContextItem("eventBus");
                                                                                    }
                                                                                    RunContextItem rci4 = new RunContextItem();
                                                                                    rci4.setAutoCreated(true);
                                                                                    RunContextItemCollection rcic = this.contexts.get(rci4.getContextImpl());
                                                                                    rci4.setItemName(view.getViewName().getNameString() + "RCI");
                                                                                    rci4.addDescription("The auto generated run context item for the " + view.getViewName());
                                                                                    if (view.getSubpackage() == null) {
                                                                                        rci4.setUseClass(this.currentModule.getGenPackage() + ".extended." + view.getViewName());
                                                                                    } else {
                                                                                        rci4.setUseClass(this.currentModule.getGenPackage() + ".extended." + view.getSubpackage() + "." + view.getViewName());
                                                                                    }
                                                                                    if (view.getUsesRunContextItemHasValue()) {
                                                                                        if (view.isCodeSplit().booleanValue()) {
                                                                                            rci4.setConstruction("new " + view.getViewName() + "(presenter, thisContext)");
                                                                                        } else {
                                                                                            rci4.setConstruction("new " + view.getViewName() + "(presenter, this)");
                                                                                        }
                                                                                    } else {
                                                                                        rci4.setConstruction("new " + view.getViewName() + "(presenter)");
                                                                                    }
                                                                                    rci4.setView(view);
                                                                                    rci4.setDefinedInModule(view.getDefinedInModule());
                                                                                    if (rcic == null) {
                                                                                        rcic = new RunContextItemCollection(rci4.getContextImpl());
                                                                                        this.contexts.put(rci4.getContextImpl(), rcic);
                                                                                    }
                                                                                    rcic.addItem(rci4);
                                                                                    rci4.getDefinedInModule().addRunContextItem(rci4);
                                                                                    rci4.setCreateOnDemand(true);
                                                                                    view.setRunContextItem(rci4);
                                                                                    break block46;
                                                                                }
                                                                                if (!(def instanceof Event)) break block56;
                                                                                this.events.put(def.getCamelCaseName(), (Event)def);
                                                                                break block46;
                                                                            }
                                                                            if (!(def instanceof Place)) break block57;
                                                                            this.places.put(def.getCamelCaseName(), (Place)def);
                                                                            break block46;
                                                                        }
                                                                        if (!(def instanceof SubPlace)) break block58;
                                                                        this.subPlaces.put(def.getCamelCaseName(), (SubPlace)def);
                                                                        break block46;
                                                                    }
                                                                    if (!(def instanceof EnumMappingGenerator)) break block59;
                                                                    this.enumGenerators.put(def.getCamelCaseName(), (EnumMappingGenerator)def);
                                                                    break block46;
                                                                }
                                                                if (!(def instanceof PropertyAccessGenerator)) break block60;
                                                                this.propertyAccessGenerators.put(def.getCamelCaseName(), (PropertyAccessGenerator)def);
                                                                break block46;
                                                            }
                                                            if (!(def instanceof RunContextItem)) break block61;
                                                            rci = (RunContextItem)def;
                                                            RunContextItemCollection rcic = this.contexts.get(rci.getContextImpl());
                                                            if (rcic == null) {
                                                                rcic = new RunContextItemCollection(rci.getContextImpl());
                                                                this.contexts.put(rci.getContextImpl(), rcic);
                                                            }
                                                            rcic.addItem(rci);
                                                            rci.getDefinedInModule().addRunContextItem(rci);
                                                            break block46;
                                                        }
                                                        if (!(def instanceof I18NConfig)) break block62;
                                                        I18NConfig i18n = (I18NConfig)def;
                                                        RunContextItemCollection rcic = this.contexts.get(i18n.getContextImpl());
                                                        if (rcic == null) {
                                                            rcic = new RunContextItemCollection(i18n.getContextImpl());
                                                            this.contexts.put(i18n.getContextImpl(), rcic);
                                                        }
                                                        rcic.addItem(i18n);
                                                        i18n.getDefinedInModule().addRunContextItem(i18n);
                                                        break block46;
                                                    }
                                                    if (!(def instanceof MenuBar)) break block63;
                                                    menu = (MenuBar)def;
                                                    this.menuBars.put(menu.getCamelCaseName(), (MenuBar)menu);
                                                    this.menuElements.put(menu.getCamelCaseName(), menu);
                                                    break block46;
                                                }
                                                if (!(def instanceof SubMenu)) break block64;
                                                menu = (SubMenu)def;
                                                this.subMenus.put(menu.getCamelCaseName(), (SubMenu)menu);
                                                this.menuElements.put(menu.getCamelCaseName(), menu);
                                                break block46;
                                            }
                                            if (!(def instanceof MenuItem)) break block65;
                                            MenuItem item = (MenuItem)def;
                                            this.menuItems.put(item.getCamelCaseName(), item);
                                            this.menuElements.put(item.getCamelCaseName(), item);
                                            break block46;
                                        }
                                        if (!(def instanceof Separator)) break block66;
                                        Separator sep = (Separator)def;
                                        this.separators.put(sep.getCamelCaseName(), sep);
                                        this.menuElements.put(sep.getCamelCaseName(), sep);
                                        break block46;
                                    }
                                    if (!(def instanceof ActionBinding)) break block67;
                                    ActionBinding action = (ActionBinding)def;
                                    this.actions.put(action.getCamelCaseName(), action);
                                    break block46;
                                }
                                if (!(def instanceof MenuImplementationConfig)) break block68;
                                if (this.menuImplementation != null) {
                                    MenuImplementationConfig config = (MenuImplementationConfig)def;
                                    ResultException ex = new ResultException();
                                    ex.addError("Multiple menu implementations are specified as part of your loaded modules; only one menu implementation can be used.");
                                    ex.result.lastResult().moreMessages("Menus from " + this.menuImplementation.getConfigName() + " defined in module " + this.menuImplementation.getDefinedInModule().getModuleName());
                                    ex.result.lastResult().moreMessages("Menus from " + config.getConfigName() + " defined in module " + config.getDefinedInModule().getModuleName());
                                    throw ex;
                                }
                                this.menuImplementation = (MenuImplementationConfig)def;
                                rci = new RunContextItem();
                                rci.setAutoCreated(true);
                                RunContextItemCollection rcic = this.contexts.get(rci.getContextImpl());
                                rci.setItemName("menuFactory");
                                rci.addDescription("The auto generated run context item for the generic menuFactory; this was created because a MenuImplementationConfig was provided by the " + this.menuImplementation.getDefinedInModule().getModuleName() + " module");
                                rci.setUseClass("org.dmd.mvw.client.mvwmenus.base.MvwMenuFactory");
                                rci.setItemOrder(16);
                                rci.setConstruction("new " + this.menuImplementation.getUseClass() + "()");
                                rci.setDefinedInModule(this.menuImplementation.getDefinedInModule());
                                if (rcic == null) {
                                    rcic = new RunContextItemCollection(rci.getContextImpl());
                                    this.contexts.put(rci.getContextImpl(), rcic);
                                }
                                rcic.addItem(rci);
                                rci.getDefinedInModule().addRunContextItem(rci);
                                this.menuFactoryRCI = rci;
                                break block46;
                            }
                            if (!(def instanceof FieldEditorDefinition)) break block69;
                            FieldEditorDefinition fed = (FieldEditorDefinition)def;
                            this.fieldEditors.put(fed.getEditorName(), fed);
                            break block46;
                        }
                        if (!(def instanceof FormBindingDefinition)) break block70;
                        FormBindingDefinition fbd = (FormBindingDefinition)def;
                        this.formBindings.put(fbd.getBindingName(), fbd);
                        break block46;
                    }
                    if (!(def instanceof EnumMapping)) break block71;
                    EnumMapping gem = (EnumMapping)def;
                    this.enumMappings.put(gem.getMappingName(), gem);
                    break block46;
                }
                if (!(def instanceof PropertyAccess)) break block46;
                PropertyAccess pa = (PropertyAccess)def;
                this.propertyAccessDefs.put(pa.getPropertyAccessName(), pa);
                break block46;
            }
            while (it.hasNext()) {
                String ref = it.next();
                this.schemaParser.parseSchema(this.readSchemas, ref, !this.schemadebug);
            }
        }
        if (def instanceof Component) {
            Component component = (Component)def;
            if (component.getHandlesEventHasValue()) {
                component.getDMO().addUsesRunContextItem("eventBus");
            }
            if (component.getFiresEventHasValue()) {
                component.getDMO().addUsesRunContextItem("eventBus");
            }
            if (component.getSendsRequestHasValue()) {
                component.getDMO().addUsesRunContextItem("commsController");
                this.needMvwComms = true;
            }
        }
    }

    void setSubpackage(MvwDefinition definition) {
        Module mod = definition.getDefinedInModule();
        if (mod.isUsingStandardSubpackages().booleanValue()) {
            if (definition instanceof Component) {
                Component component = (Component)definition;
                if (component.getSubpackage() == null) {
                    if (component instanceof Controller) {
                        component.setSubpackage("controllers");
                    } else if (component instanceof Presenter) {
                        component.setSubpackage("presenters");
                    } else if (component instanceof Activity) {
                        component.setSubpackage("activities");
                    }
                }
            } else if (definition instanceof View && ((View)definition).getSubpackage() == null) {
                ((View)definition).setSubpackage("views");
            }
        }
    }

    public void resolveDefinitions() throws ResultException, DmcValueException, DmcNameClashException {
        ClassDefinition cd;
        ResultException errors = null;
        if (this.needMvwComms) {
            this.key.setNameString("mvwcomms");
            if (this.modules.get(this.key) == null) {
                ResultException ex = new ResultException();
                ex.addError("One or more of your components specify that they send Dark Matter Protocol messages, but you haven't loaded the mvwcomms module.");
                throw ex;
            }
        }
        for (MvwDefinition def : this.allDefs.values()) {
            try {
                def.resolveReferences(this, this);
            }
            catch (DmcValueExceptionSet e) {
                if (errors == null) {
                    errors = new ResultException();
                }
                errors.addError("Couldn't resolve references in object:  " + def.getCamelCaseName());
                errors.setLocationInfo(def.getFile(), def.getLineNumber().intValue());
                for (DmcValueException dve : e.getExceptions()) {
                    errors.moreMessages(dve.getMessage());
                }
            }
        }
        for (Controller controller : this.controllers.values()) {
            if (!controller.getImplementsActionHasValue()) continue;
            Iterator e = controller.getImplementsActionIterable().iterator();
            while (e.hasNext()) {
                ActionBinding action = (ActionBinding)e.next();
                if (action.getImplementedBy() == null) {
                    action.setImplementedBy(controller);
                    continue;
                }
                if (errors == null) {
                    errors = new ResultException();
                }
                Component existing = action.getImplementedBy();
                errors.addError("Multiple components implement the " + action.getActionBindingName() + " action.");
                errors.result.lastResult().moreMessages(existing.getComponentName() + " in file " + existing.getFile() + ":" + existing.getLineNumber());
                errors.result.lastResult().moreMessages(controller.getComponentName() + " in file " + controller.getFile() + ":" + controller.getLineNumber());
            }
            if (!controller.getDefinedInModule().dependsOnModuleContains("mvwmenus")) {
                if (errors == null) {
                    errors = new ResultException();
                }
                errors.addError("The " + controller.getDefinedInModule().getModuleName() + " module must depend on the mvwmenus module.");
                errors.result.lastResult().moreMessages(controller.getDefinedInModule().getFile());
                continue;
            }
            this.key.setNameString("MenuControllerRCI");
            RunContextItemCollection rcic = this.contexts.get("Default");
            RunContextItem rci = rcic.getItem("MenuControllerRCI");
            controller.addUsesRunContextItem(rci);
        }
        for (ActionBinding action : this.actions.values()) {
            if (action.getImplementedBy() != null) continue;
            if (errors == null) {
                errors = new ResultException();
            }
            errors.addError("The " + action.getActionBindingName() + " action is not implemented by any Controller, Presenter or Activity.");
        }
        if (this.application != null) {
            if (this.centralAsyncErrorHandler != null) {
                DebugInfo.debug((String)"CHANGING THE PLACEHOLDER");
                RunContextItemCollection rcic = this.contexts.get(this.centralAsyncErrorHandlerRCI.getContextImpl());
                RunContextItem rci = rcic.getItem("centralAsyncErrorHandler");
                rci.setConstruction(this.centralAsyncErrorHandlerRCI.getItemName());
                int order = this.centralAsyncErrorHandlerRCI.getItemOrder() + 1;
                rci.setItemOrder(order);
            }
            if (this.menuBars.size() > 0) {
                if (this.application.getMenuImplementation() == null) {
                    if (errors == null) {
                        errors = new ResultException();
                    }
                    errors.addError("The " + this.application.getAppName() + " uses menu functionality and you must set the menuImplementation.");
                }
                try {
                    this.menuImplementation.validateImplementations(this.menuElements);
                }
                catch (ResultException ex) {
                    if (errors == null) {
                        errors = ex;
                    }
                    errors.result.addResults(ex.result);
                }
                RunContextItem rci = new RunContextItem();
                rci.setAutoCreated(true);
                RunContextItemCollection rcic = this.contexts.get(rci.getContextImpl());
                rci.setItemName("menuBuilder");
                rci.setItemOrder(200);
                rci.setUseClass(this.application.getDefinedInModule().getGenPackage() + ".generated.mvw." + this.application.getAppName() + "MenuBuilder");
                rci.setConstruction("new " + this.application.getAppName() + "MenuBuilder(this)");
                rci.setDefinedInModule(this.application.getDefinedInModule());
                if (rcic == null) {
                    rcic = new RunContextItemCollection(rci.getContextImpl());
                    this.contexts.put(rci.getContextImpl(), rcic);
                }
                rcic.addItem(rci);
                rci.getDefinedInModule().addRunContextItem(rci);
                for (MenuElementDefinitionDMW def : this.menuElements.values()) {
                    try {
                        if (def instanceof MenuItem) {
                            MenuItem item = (MenuItem)def;
                            item.initLabelInfo(this.defaultContext);
                            continue;
                        }
                        if (!(def instanceof SubMenu)) continue;
                        SubMenu submenu = (SubMenu)def;
                        submenu.initLabelInfo(this.defaultContext);
                    }
                    catch (ResultException ex) {
                        if (errors == null) {
                            errors = ex;
                            continue;
                        }
                        errors.result.addResults(ex.result);
                    }
                }
            }
        }
        if (this.formBindings.size() > 0) {
            for (FormBindingDefinition fbd : this.formBindings.values()) {
                if (fbd.getDefinedInModule() != this.codeGenModule) continue;
                Iterator order = fbd.getEditFieldIterable().iterator();
                while (order.hasNext()) {
                    EditField field = (EditField)order.next();
                    this.key.setNameString(field.getFieldEditor());
                    FieldEditorDefinition fed = this.fieldEditors.get(this.key);
                    if (fed == null) {
                        if (errors == null) {
                            errors = new ResultException();
                        }
                        errors.addError("Unknown FieldEditorDefinition reference: " + field.getFieldEditor());
                        errors.result.lastResult().fileName(fbd.getFile());
                        errors.result.lastResult().lineNumber(fbd.getLineNumber().intValue());
                    } else {
                        field.setEditorDef(fed);
                    }
                    AttributeDefinition def = this.readSchemas.adef(field.getAttribute());
                    if (def == null) {
                        if (errors == null) {
                            errors = new ResultException();
                        }
                        errors.addError("Unknown attribute reference: " + field.getAttribute());
                        errors.result.lastResult().fileName(fbd.getFile());
                        errors.result.lastResult().lineNumber(fbd.getLineNumber().intValue());
                        continue;
                    }
                    field.setAttrDef(def);
                    if (!fbd.isStrictlyChecked().booleanValue() || (cd = fbd.getEditObject()).hasAttribute(def.getName().getNameString()) != null) continue;
                    if (errors == null) {
                        errors = new ResultException();
                    }
                    errors.addError("Attribute: " + field.getAttribute() + " is not an attribute of editObject: " + cd.getName());
                    errors.result.lastResult().fileName(fbd.getFile());
                    errors.result.lastResult().lineNumber(fbd.getLineNumber().intValue());
                }
            }
        }
        if (this.enumMappings.size() > 0) {
            for (EnumMapping mapping : this.enumMappings.values()) {
                if (mapping.getDefinedInModule() != this.codeGenModule) continue;
                EnumDefinition ed = this.readSchemas.isEnum(mapping.getEnumName());
                if (ed == null) {
                    if (errors == null) {
                        errors = new ResultException();
                    }
                    errors.addError(mapping.getEnumName() + " is not a known enum type.");
                    errors.result.lastResult().fileName(mapping.getFile());
                    errors.result.lastResult().lineNumber(mapping.getLineNumber().intValue());
                    continue;
                }
                mapping.setEnumDef(ed);
                EnumValue ev = ed.getEnumValue(mapping.getUnsetValue());
                if (ev != null) continue;
                if (errors == null) {
                    errors = new ResultException();
                }
                errors.addError(mapping.getUnsetValue() + " is not a valid member of enum: " + ed.getName());
                errors.result.lastResult().fileName(mapping.getFile());
                errors.result.lastResult().lineNumber(mapping.getLineNumber().intValue());
            }
        }
        if (this.components.size() > 0) {
            for (Component component : this.components.values()) {
                if (!component.getSendsRequestHasValue()) continue;
                if (this.readSchemas.isSchema("dmp") == null) {
                    DmpSchemaAG dmp = new DmpSchemaAG();
                    this.readSchemas.manageSchema((SchemaDefinition)dmp);
                }
                component.getDMO().addUsesRunContextItem("commsController");
                this.needMvwComms = true;
                Iterator iterator = component.getSendsRequestIterable().iterator();
                while (iterator.hasNext()) {
                    RequestTypeWithOptions rq = (RequestTypeWithOptions)iterator.next();
                    String request = rq.getRequestType() + "Request";
                    String response = rq.getRequestType() + "Response";
                    cd = this.readSchemas.cdef(request);
                    if (cd == null) {
                        ResultException ex = new ResultException();
                        ex.addError("Unknown request type: " + request);
                        ex.result.lastResult().lineNumber(component.getLineNumber().intValue());
                        ex.result.lastResult().fileName(component.getFile());
                        throw ex;
                    }
                    rq.setRequestImport(cd.getDmoImport());
                    cd = this.readSchemas.cdef(response);
                    if (cd == null) {
                        ResultException ex = new ResultException();
                        ex.addError("Unknown response type: " + response);
                        ex.result.lastResult().lineNumber(component.getLineNumber().intValue());
                        ex.result.lastResult().fileName(component.getFile());
                        throw ex;
                    }
                    rq.setResponseImport(cd.getDmoImport());
                    if (!rq.isUsingClassInfo()) continue;
                    cd = this.readSchemas.cdef(rq.getClassName());
                    if (cd == null) {
                        ResultException ex = new ResultException();
                        ex.addError("Unknown class: " + rq.getClassName() + " in " + rq.getRequestType() + "Request spec");
                        ex.result.lastResult().lineNumber(component.getLineNumber().intValue());
                        ex.result.lastResult().fileName(component.getFile());
                        throw ex;
                    }
                    rq.setClassImport(cd.getDmoImport());
                    if (!rq.getRequestType().equals("Set") && !rq.getRequestType().equals("Delete") || cd.getIsNamedBy() != null) continue;
                    ResultException ex = new ResultException();
                    ex.addError(rq.getRequestType() + "Requests are only applicable to named objects.");
                    ex.result.lastResult().lineNumber(component.getLineNumber().intValue());
                    ex.result.lastResult().fileName(component.getFile());
                    throw ex;
                }
            }
        }
        if (errors != null) {
            throw errors;
        }
        this.initCodeGenInfo();
    }

    void initCodeGenInfo() throws DmcValueException, ResultException {
        boolean rpc = false;
        boolean dmp = false;
        boolean needAsyncErrorHandler = false;
        if (this.centralDmpErrorHandler != null) {
            dmp = true;
        }
        if (this.centralRpcErrorHandler != null) {
            rpc = true;
        }
        for (View view : this.views.values()) {
            view.initCodeGenInfo();
        }
        for (Controller controller : this.controllers.values()) {
            controller.initCodeGenInfo(rpc, dmp);
        }
        for (Presenter presenter : this.presenters.values()) {
            presenter.initCodeGenInfo(rpc, dmp);
        }
        for (Activity activity : this.activities.values()) {
            activity.initCodeGenInfo(rpc, dmp);
            if (!activity.isCodeSplit().booleanValue()) continue;
            needAsyncErrorHandler = true;
        }
        for (Event event : this.events.values()) {
            event.checkSanity();
        }
        for (Place place : this.places.values()) {
            place.initCodeGenInfo();
        }
        for (EnumMappingGenerator enumMappingGenerator : this.enumGenerators.values()) {
            enumMappingGenerator.init();
        }
        for (PropertyAccessGenerator propertyAccessGenerator : this.propertyAccessGenerators.values()) {
            propertyAccessGenerator.init();
        }
        for (ActionBinding actionBinding : this.actions.values()) {
            actionBinding.initCodeGenInfo();
        }
        if (this.application != null && needAsyncErrorHandler && this.centralAsyncErrorHandler == null) {
            ResultException ex = new ResultException();
            ex.addError("One or more elements make use of code splitting, but no Controller is defined as the centralAsyncErrorHandler.");
            throw ex;
        }
    }

    void resetCodeGenInfo() {
        for (View view : this.views.values()) {
            view.resetCodeGenInfo();
        }
        for (Controller controller : this.controllers.values()) {
            controller.resetCodeGenInfo();
        }
        for (Presenter presenter : this.presenters.values()) {
            presenter.resetCodeGenInfo();
        }
        for (Activity activity : this.activities.values()) {
            activity.resetCodeGenInfo();
        }
        for (Event event : this.events.values()) {
            event.resetCodeGenInfo();
        }
        for (Place place : this.places.values()) {
            place.resetCodeGenInfo();
        }
        for (ActionBinding action : this.actions.values()) {
            action.resetCodeGenInfo();
        }
    }

    void checkAndAdd(MvwDefinition def, TreeMap map) throws ResultException {
        MvwDefinition existing = (MvwDefinition)((Object)map.get(def.getCamelCaseName()));
        if (existing != null) {
            ResultException ex = new ResultException();
            ex.addError("The definition with name: " + def.getCamelCaseName() + " clashes with an existing definition.");
            ex.result.lastResult().moreMessages("Existing definition from file: " + def.getDefinedInModule().getFile());
            ex.setLocationInfo(def.getFile(), def.getLineNumber().intValue());
            throw ex;
        }
        map.put(def.getCamelCaseName(), def);
    }

    public DmcObject findNamedDMO(DmcObjectName name) {
        DmcObject rc = null;
        MvwDefinition d = this.allDefs.get(name);
        if (d == null) {
            rc = this.schema.findNamedDMO(name);
            if (rc == null) {
                rc = this.readSchemas.findNamedDMO(name);
            }
        } else {
            rc = d.getDmcObject();
        }
        return rc;
    }

    public DmcNamedObjectIF findNamedObject(DmcObjectName name) {
        DmcNamedObjectIF rc = null;
        MvwDefinition d = this.allDefs.get(name);
        if (d == null) {
            rc = this.schema.findNamedObject(name);
            if (rc == null) {
                rc = this.readSchemas.findNamedObject(name);
            }
        } else {
            rc = (DmcNamedObjectIF)d.getDmcObject();
        }
        return rc;
    }

    public DmcNamedObjectIF findNamedObject(DmcObjectName name, int attributeID) {
        return this.findNamedObject(name);
    }

    public SchemaManager getSchema() {
        return this.schema;
    }

    public SchemaManager getReadSchemas() {
        return this.readSchemas;
    }

    public TreeMap<CamelCaseName, MvwDefinition> getAllDefs() {
        return this.allDefs;
    }

    public TreeMap<CamelCaseName, Module> getModules() {
        return this.modules;
    }

    public TreeMap<CamelCaseName, Event> getEvents() {
        return this.events;
    }

    public TreeMap<CamelCaseName, Controller> getControllers() {
        return this.controllers;
    }

    public TreeMap<CamelCaseName, Presenter> getPresenters() {
        return this.presenters;
    }

    public TreeMap<CamelCaseName, Activity> getActivities() {
        return this.activities;
    }

    public TreeMap<CamelCaseName, Component> getComponents() {
        return this.components;
    }

    public TreeMap<CamelCaseName, Place> getPlaces() {
        return this.places;
    }

    public TreeMap<CamelCaseName, SubPlace> getSubPlaces() {
        return this.subPlaces;
    }

    public TreeMap<CamelCaseName, EnumMappingGenerator> getEnumGenerators() {
        return this.enumGenerators;
    }

    public TreeMap<CamelCaseName, PropertyAccessGenerator> getPropertyAccessGenerators() {
        return this.propertyAccessGenerators;
    }

    public TreeMap<CamelCaseName, View> getViews() {
        return this.views;
    }

    public Controller getCentralRpcErrorHandler() {
        return this.centralRpcErrorHandler;
    }

    public Controller getCentralDmpErrorHandler() {
        return this.centralDmpErrorHandler;
    }

    public TreeMap<String, RunContextItemCollection> getContexts() {
        return this.contexts;
    }

    public String getControllerSubpackage() {
        return "controllers";
    }

    public String getPresenterSubpackage() {
        return "presenters";
    }

    public String getViewSubpackage() {
        return "views";
    }

    public String getActivitySubpackage() {
        return "activities";
    }

    public RunContextItem getMenuFactoryRCI() {
        return this.menuFactoryRCI;
    }

    public TreeMap<CamelCaseName, MenuElementDefinitionDMW> getMenuElements() {
        return this.menuElements;
    }

    public TreeMap<CamelCaseName, ActionBinding> getActions() {
        return this.actions;
    }

    public TreeMap<CamelCaseName, FieldEditorDefinition> getFieldEditors() {
        return this.fieldEditors;
    }

    public void mergeDefinitions(MvwDefinitionManager mdm) throws DmcNameClashException {
        Iterator schemas = mdm.readSchemas.getSchemas();
        while (schemas.hasNext()) {
            SchemaDefinition sd = (SchemaDefinition)schemas.next();
            try {
                if (this.readSchemas.isSchema(sd.getName().getNameString()) != null) continue;
                this.readSchemas.manageSchemaInternal(sd, false);
            }
            catch (ResultException resultException) {
                resultException.printStackTrace();
            }
            catch (DmcValueException dmcValueException) {
                dmcValueException.printStackTrace();
            }
        }
        if (mdm.application != null) {
            this.allDefs.put(mdm.application.getCamelCaseName(), mdm.application);
        }
        for (Module module : mdm.modules.values()) {
            this.modules.put(module.getCamelCaseName(), module);
            this.allDefs.put(module.getCamelCaseName(), module);
        }
        for (Event event : mdm.events.values()) {
            this.events.put(event.getCamelCaseName(), event);
            this.allDefs.put(event.getCamelCaseName(), event);
        }
        for (Controller controller : mdm.controllers.values()) {
            this.controllers.put(controller.getCamelCaseName(), controller);
            this.allDefs.put(controller.getCamelCaseName(), controller);
        }
        for (Presenter presenter : mdm.presenters.values()) {
            this.presenters.put(presenter.getCamelCaseName(), presenter);
            this.allDefs.put(presenter.getCamelCaseName(), presenter);
        }
        for (Activity activity : mdm.activities.values()) {
            this.activities.put(activity.getCamelCaseName(), activity);
            this.allDefs.put(activity.getCamelCaseName(), activity);
        }
        for (Place place : mdm.places.values()) {
            this.places.put(place.getCamelCaseName(), place);
            this.allDefs.put(place.getCamelCaseName(), place);
        }
        for (SubPlace subPlace : mdm.subPlaces.values()) {
            this.subPlaces.put(subPlace.getCamelCaseName(), subPlace);
            this.allDefs.put(subPlace.getCamelCaseName(), subPlace);
        }
        for (EnumMappingGenerator enumMappingGenerator : mdm.enumGenerators.values()) {
            this.enumGenerators.put(enumMappingGenerator.getCamelCaseName(), enumMappingGenerator);
            this.allDefs.put(enumMappingGenerator.getCamelCaseName(), enumMappingGenerator);
        }
        for (PropertyAccessGenerator propertyAccessGenerator : mdm.propertyAccessGenerators.values()) {
            this.propertyAccessGenerators.put(propertyAccessGenerator.getCamelCaseName(), propertyAccessGenerator);
            this.allDefs.put(propertyAccessGenerator.getCamelCaseName(), propertyAccessGenerator);
        }
        for (View view : mdm.views.values()) {
            this.views.put(view.getCamelCaseName(), view);
            this.allDefs.put(view.getCamelCaseName(), view);
        }
        for (ActionBinding actionBinding : mdm.actions.values()) {
            this.actions.put(actionBinding.getCamelCaseName(), actionBinding);
            this.allDefs.put(actionBinding.getCamelCaseName(), actionBinding);
        }
        for (RunContextItemCollection runContextItemCollection : mdm.contexts.values()) {
            RunContextItemCollection ourCollection = this.contexts.get(runContextItemCollection.implName);
            if (ourCollection == null) {
                System.out.println("UNKNOWN CONTEXT: " + runContextItemCollection.implName);
                System.exit(1);
            }
            for (RunContextItem rci : runContextItemCollection.getItemsByName().values()) {
                if (ourCollection.getItem(rci.getItemName().getNameString()) != null) continue;
                try {
                    ourCollection.addItem(rci);
                }
                catch (ResultException e) {
                    e.printStackTrace();
                }
                try {
                    this.allDefs.put(rci.getCamelCaseName(), rci);
                }
                catch (Exception ex) {
                    System.out.println(ex.toString());
                    System.out.println(rci.toOIF());
                    System.exit(1);
                }
            }
        }
    }

    public void prepAggregatedInfo() {
        for (MvwDefinition def : this.allDefs.values()) {
            System.out.println(def.getCamelCaseName());
        }
        for (MvwDefinition def : this.allDefs.values()) {
            def.getDMO().clearReferenceInfo();
        }
        this.resetCodeGenInfo();
        DmcOmni.instance().backRefTracking(true);
        for (MvwDefinition def : this.allDefs.values()) {
            try {
                def.getDMO().resolveReferences(this, this);
            }
            catch (DmcValueExceptionSet e) {
                e.printStackTrace();
                System.out.println("\nWhile resolving: \n" + def.getDMO().toOIF());
            }
        }
        try {
            this.initCodeGenInfo();
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
        catch (ResultException e) {
            e.printStackTrace();
        }
    }

    public DmcNamedObjectIF findNamedObjectMayClash(DmcObject object, DmcObjectName name, DmcNameClashResolverIF resolver, DmcAttributeInfo ai) throws DmcValueException {
        DmcNamedObjectIF rc = null;
        MvwDefinition d = this.allDefs.get(name);
        if (d == null) {
            rc = this.schema.findNamedObjectMayClash(object, name, (DmcNameClashResolverIF)this.schema, ai);
            if (rc == null) {
                rc = this.readSchemas.findNamedObjectMayClash(object, name, (DmcNameClashResolverIF)this.readSchemas, ai);
            }
        } else {
            rc = (DmcNamedObjectIF)d.getDmcObject();
        }
        return rc;
    }

    public DmcNamedObjectIF resolveClash(DmcObject obj, DmcAttributeInfo ai, DmcNameClashObjectSet<?> ncos) throws DmcValueException {
        MvwDefinition rc = null;
        MvwDefinition resolving = (MvwDefinition)obj.getContainer();
        Iterator it = ncos.getMatches();
        while (it.hasNext()) {
            MvwDefinition def = (MvwDefinition)((Object)it.next());
            if (!resolving.getDefinedInModule().equals((Object)def.getDefinedInModule())) continue;
            rc = def;
            break;
        }
        return rc;
    }
}

