/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.util;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.dmd.mvw.tools.mvwgenerator.extended.Activity;
import org.dmd.mvw.tools.mvwgenerator.extended.Component;
import org.dmd.mvw.tools.mvwgenerator.extended.Controller;
import org.dmd.mvw.tools.mvwgenerator.extended.Event;
import org.dmd.mvw.tools.mvwgenerator.extended.Place;
import org.dmd.mvw.tools.mvwgenerator.extended.Presenter;
import org.dmd.mvw.tools.mvwgenerator.extended.PropertyAccess;
import org.dmd.mvw.tools.mvwgenerator.extended.View;
import org.dmd.mvw.tools.mvwgenerator.extended.forms.EnumMapping;
import org.dmd.mvw.tools.mvwgenerator.extended.forms.FormBindingDefinition;
import org.dmd.mvw.tools.mvwgenerator.extended.menus.ActionBinding;
import org.dmd.mvw.tools.mvwgenerator.util.ActionBindingFormatter;
import org.dmd.mvw.tools.mvwgenerator.util.ActivityFormatter;
import org.dmd.mvw.tools.mvwgenerator.util.ControllerFormatter;
import org.dmd.mvw.tools.mvwgenerator.util.FormBindingFormatter;
import org.dmd.mvw.tools.mvwgenerator.util.GwtEventFormatter;
import org.dmd.mvw.tools.mvwgenerator.util.MenuBuilderFormatter;
import org.dmd.mvw.tools.mvwgenerator.util.MvwDefinitionManager;
import org.dmd.mvw.tools.mvwgenerator.util.PlaceFormatter;
import org.dmd.mvw.tools.mvwgenerator.util.PresenterFormatter;
import org.dmd.mvw.tools.mvwgenerator.util.RunContextFormatter;
import org.dmd.mvw.tools.mvwgenerator.util.ViewFormatter;
import org.dmd.mvw.tools.mvwgenerator.util.WebApplicationFormatter;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.ConfigLocation;

public class MvwGenerator {
    String extendir;
    String gendir;
    String mvwdir;
    String eventsdir;
    String viewsdir;
    String controllersdir;
    String presentersdir;
    String placesdir;
    String activitiesdir;
    String actionsdir;
    String formsdir;
    String propertiesdir;
    PrintStream progressStream;
    MvwDefinitionManager defManager;

    public MvwGenerator(MvwDefinitionManager dm, PrintStream ps) {
        this.defManager = dm;
        this.progressStream = ps;
    }

    public void generateCode(ConfigLocation loc) throws IOException, ResultException {
        this.gendir = loc.getConfigParentDirectory() + File.separator + "generated";
        this.extendir = loc.getConfigParentDirectory() + File.separator + "extended";
        this.mvwdir = this.gendir + File.separator + "mvw";
        this.eventsdir = this.mvwdir + File.separator + "events";
        this.viewsdir = this.mvwdir + File.separator + "views";
        this.controllersdir = this.mvwdir + File.separator + "controllers";
        this.presentersdir = this.mvwdir + File.separator + "presenters";
        this.activitiesdir = this.mvwdir + File.separator + "activities";
        this.actionsdir = this.mvwdir + File.separator + "actions";
        this.placesdir = this.mvwdir + File.separator + "places";
        this.formsdir = this.mvwdir + File.separator + "forms";
        this.propertiesdir = this.mvwdir + File.separator + "properties";
        this.createGenDir(this.gendir);
        if (this.defManager.getCodeGenModule() == null) {
            return;
        }
        if (!this.defManager.getCodeGenModule().getModuleName().equals((Object)loc.getConfigName())) {
            System.out.println("\nThe " + loc.getConfigName() + ".mvw config file is empty - no code generated");
            return;
        }
        this.createGenDir(this.mvwdir);
        if (this.defManager.events.size() > 0) {
            for (Event event : this.defManager.events.values()) {
                if (event.getDefinedInModule() != this.defManager.codeGenModule) continue;
                this.createGenDir(this.eventsdir);
                GwtEventFormatter.formatEvent(this.eventsdir, event);
            }
        }
        if (this.defManager.views.size() > 0) {
            for (View view : this.defManager.views.values()) {
                if (view.getDefinedInModule() != this.defManager.codeGenModule) continue;
                this.createGenDir(this.viewsdir);
                ViewFormatter.formatViewInterface(this.viewsdir, view);
                ViewFormatter.formatViewBaseImpl(this.viewsdir, view);
                ViewFormatter.formatInitialView(this.extendir, view);
            }
        }
        if (this.defManager.controllers.size() > 0) {
            for (Controller controller : this.defManager.controllers.values()) {
                if (controller.getDefinedInModule() != this.defManager.codeGenModule) continue;
                this.createGenDir(this.controllersdir);
                ControllerFormatter.formatControllerBaseImpl(this.controllersdir, controller);
                if (!controller.getImplementsActionHasValue()) continue;
                Iterator iterator = controller.getImplementsActionIterable().iterator();
                while (iterator.hasNext()) {
                    ActionBinding action = (ActionBinding)iterator.next();
                    this.createGenDir(this.actionsdir);
                    ActionBindingFormatter.formatAction(this.actionsdir, action, controller);
                }
            }
        }
        if (this.defManager.presenters.size() > 0) {
            for (Presenter presenter : this.defManager.presenters.values()) {
                if (presenter.getDefinedInModule() != this.defManager.codeGenModule) continue;
                this.createGenDir(this.presentersdir);
                PresenterFormatter.formatPresenterBaseImpl(this.presentersdir, presenter);
                PresenterFormatter.formatInitialPresenter(this.extendir, presenter);
            }
        }
        if (this.defManager.activities.size() > 0) {
            for (Activity activity : this.defManager.activities.values()) {
                if (activity.getDefinedInModule() != this.defManager.codeGenModule) continue;
                this.createGenDir(this.activitiesdir);
                ActivityFormatter.formatActivity(this.activitiesdir, activity);
                ActivityFormatter.formatInitialActivity(this.extendir, activity);
            }
        }
        if (this.defManager.getFormBindings().size() > 0) {
            for (FormBindingDefinition fbd : this.defManager.getFormBindings().values()) {
                if (fbd.getDefinedInModule() != this.defManager.codeGenModule) continue;
                this.createGenDir(this.formsdir);
                FormBindingFormatter.formatFormBinding(this.formsdir, fbd);
            }
        }
        if (this.defManager.getEnumMappings().size() > 0) {
            for (EnumMapping gem : this.defManager.getEnumMappings().values()) {
                if (gem.getDefinedInModule() != this.defManager.codeGenModule) continue;
                this.createGenDir(this.formsdir);
                gem.getMappingGenerator().formatEnumMapping(this.formsdir, gem);
            }
        }
        if (this.defManager.getPropertyAccessGenerators().size() > 0) {
            for (PropertyAccess pa : this.defManager.getPropertyAccessDefs().values()) {
                if (pa.getDefinedInModule() != this.defManager.codeGenModule) continue;
                this.createGenDir(this.propertiesdir);
                pa.getAccessGenerator().formatPropertyAccess(this.propertiesdir, pa);
            }
        }
        if (this.defManager.places.size() > 0) {
            for (Place place : this.defManager.places.values()) {
                if (place.getDefinedInModule() != this.defManager.codeGenModule) continue;
                this.createGenDir(this.placesdir);
                PlaceFormatter.formatPlace(this.placesdir, place);
            }
        }
        if (this.defManager.getCodeGenModule() != null) {
            DebugInfo.debug((String)("Generating run context for: " + this.defManager.getCodeGenModule().getFile()));
            RunContextFormatter.formatModuleRunContextInterface(this.mvwdir, this.defManager.getCodeGenModule(), this.defManager.getDefaultContext());
        }
        if (this.defManager.getApplication() != null) {
            ArrayList<Component> centralRC = this.defManager.centralDmpErrorHandlingOK();
            if (centralRC != null) {
                System.err.println("The following components require a central DMP error handler to be defined:\n");
                for (Component component : centralRC) {
                    System.err.println(component.getObjectName().getNameString() + " in file: " + component.getFile());
                }
                System.err.println("\nAt least one controller must have its centralDMPErrorHandler flag set to true.\n\n");
                System.exit(1);
            }
            if ((centralRC = this.defManager.centralRpcErrorHandlingOK()) != null) {
                System.err.println("The following components require a central RPC error handler to be defined:\n");
                for (Component component : centralRC) {
                    System.err.println(component.getObjectName().getNameString() + " in file: " + component.getFile());
                }
                System.err.println("\nAt least one controller must have its centralRPCErrorHandler flag set to true.\n\n");
                System.exit(1);
            }
            this.createGenDir(this.placesdir);
            PlaceFormatter.formatPlaceHistoryMapper(this.placesdir, this.defManager.application, this.defManager.places);
            RunContextFormatter.formatAppRunContextInterface(this.mvwdir, this.defManager.getApplication(), this.defManager.getDefaultContext());
            DebugInfo.debug((String)"GENERATING RUN CONTEXT");
            RunContextFormatter.formatImplementation(this.mvwdir, this.defManager.getApplication(), this.defManager.getDefaultContext());
            WebApplicationFormatter.formatApplication(this.mvwdir, this.defManager.getApplication());
            if (this.defManager.getMenuImplementation() != null) {
                MenuBuilderFormatter.formatMenuBuilder(this.mvwdir, this.defManager);
            }
        }
    }

    void createGenDir(String dirname) {
        File dir = new File(dirname);
        if (!dir.exists()) {
            dir.mkdir();
        }
    }
}

