/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.util;

import java.util.HashMap;
import java.util.Iterator;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.dms.SchemaManager;
import org.dmd.dmv.shared.DmvRuleManager;
import org.dmd.dmw.DmwObjectFactory;
import org.dmd.mvw.tools.mvwgenerator.extended.Component;
import org.dmd.mvw.tools.mvwgenerator.extended.Module;
import org.dmd.mvw.tools.mvwgenerator.extended.MvwDefinition;
import org.dmd.mvw.tools.mvwgenerator.generated.dmo.ModuleDMO;
import org.dmd.mvw.tools.mvwgenerator.util.MvwDefinitionManager;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.ConfigFinder;
import org.dmd.util.parsing.ConfigLocation;
import org.dmd.util.parsing.ConfigVersion;
import org.dmd.util.parsing.DmcUncheckedOIFHandlerIF;
import org.dmd.util.parsing.DmcUncheckedOIFParser;

public class MvwParser
implements DmcUncheckedOIFHandlerIF {
    SchemaManager schema;
    ConfigFinder finder;
    MvwDefinitionManager defManager;
    DmwObjectFactory factory;
    DmcUncheckedOIFParser configParser;
    DmcUncheckedOIFParser defParser;
    Module currentModule;
    String currFile;
    HashMap<String, ModuleDMO> loadedFiles;
    DmvRuleManager ruleManager;
    private boolean debug;

    public MvwParser(SchemaManager sm, ConfigFinder cf, MvwDefinitionManager dm) {
        this.schema = sm;
        this.configParser = new DmcUncheckedOIFParser((DmcUncheckedOIFHandlerIF)this);
        this.defParser = new DmcUncheckedOIFParser((DmcUncheckedOIFHandlerIF)this);
        this.finder = cf;
        this.factory = new DmwObjectFactory(sm);
        this.defManager = dm;
        this.ruleManager = new DmvRuleManager();
    }

    public void debug(boolean flag) {
        this.debug = flag;
    }

    public void parseConfig(ConfigLocation cl) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        this.defManager.reset();
        this.parseConfigInternal(cl);
        this.defManager.resolveDefinitions();
    }

    void parseConfigInternal(ConfigLocation cl) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        Iterator<String> refs;
        if (this.debug) {
            if (cl.isFromJAR()) {
                System.out.println("Reading: " + cl.getFileName() + " - from " + cl.getJarFilename());
            } else {
                System.out.println("Reading: " + cl.getFileName());
            }
        }
        if (cl.isFromJAR()) {
            this.configParser.parseFile(cl.getFileName(), true);
        } else {
            this.configParser.parseFile(cl.getFileName());
        }
        ModuleDMO moduleDMO = (ModuleDMO)this.currentModule.getDmcObject();
        if (moduleDMO.getModuleName() != null && !moduleDMO.getModuleName().equals((Object)"mvw")) {
            moduleDMO.addDependsOnModule("mvw");
        }
        if ((refs = moduleDMO.getDependsOnModule()) != null) {
            while (refs.hasNext()) {
                String ref = refs.next();
                ConfigVersion cv = this.finder.getConfig(ref);
                if (cv == null) {
                    ResultException ex = new ResultException();
                    ex.addError("MVW config not found: " + ref);
                    ex.setLocationInfo(this.currentModule.getFile(), this.currentModule.getLineNumber().intValue());
                    throw ex;
                }
                if (this.defManager.getModule(cv.getLatestVersion().getConfigName()) != null) continue;
                this.parseConfigInternal(cv.getLatestVersion());
            }
        }
    }

    public void handleObject(DmcUncheckedObject uco, String infile, int lineNumber) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        MvwDefinition definition = null;
        try {
            definition = (MvwDefinition)this.factory.createWrapper(uco);
        }
        catch (ClassNotFoundException e) {
            ResultException ex = new ResultException("Unknown object class: " + (String)uco.classes.get(0));
            ex.result.lastResult().fileName(infile);
            ex.result.lastResult().lineNumber(lineNumber);
            throw ex;
        }
        catch (ResultException ex) {
            ex.setLocationInfo(infile, lineNumber);
            throw ex;
        }
        catch (DmcValueException e) {
            ResultException ex = new ResultException();
            ex.addError(e.getMessage());
            if (e.getAttributeName() != null) {
                ex.result.lastResult().moreMessages("Attribute: " + e.getAttributeName());
            }
            ex.setLocationInfo(infile, lineNumber);
            throw ex;
        }
        definition.setLineNumber(lineNumber);
        definition.setFile(infile);
        definition.setCamelCaseName(definition.getObjectName());
        if (definition instanceof Module) {
            this.currentModule = (Module)definition;
        }
        if (definition instanceof Component) {
            Component c = (Component)definition;
            c.setComponentName(c.getObjectName());
        }
        definition.setDefinedInModule(this.currentModule);
        this.ruleManager.executeAttributeValidation((DmcObject)definition.getDMO());
        this.ruleManager.executeObjectValidation((DmcObject)definition.getDMO());
        this.defManager.addDefinition(definition);
        if (definition instanceof Module) {
            Module config;
            this.currentModule = config = (Module)definition;
        }
    }

    class ConfigWithLocation {
        Module config;
        ConfigLocation location;

        public ConfigWithLocation(ConfigLocation l) {
            this.location = l;
            this.config = null;
        }
    }
}

