/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.dmd.dmc.types.CheapSplitter;
import org.dmd.mvw.tools.mvwgenerator.extended.Presenter;
import org.dmd.mvw.tools.mvwgenerator.extended.RunContextItem;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.exceptions.DebugInfo;

public class PresenterFormatter {
    public static void formatPresenterBaseImpl(String outdir, Presenter presenter) throws IOException {
        RunContextItem rci;
        if (presenter.isCodeSplit().booleanValue()) {
            PresenterFormatter.formatPresenterAsyncIF(outdir, presenter);
        }
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(outdir, presenter.getPresenterName() + "BaseImpl.java");
        out.write("package " + presenter.getDefinedInModule().getGenPackage() + ".generated.mvw.presenters;\n\n");
        out.write(presenter.getImports());
        out.write("\n");
        out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("abstract public class " + presenter.getPresenterName() + "BaseImpl" + presenter.getPresenterInterfaces() + " {\n\n");
        boolean onDemand = false;
        Iterator iterator = presenter.getUsesRunContextItemIterable().iterator();
        while (iterator.hasNext()) {
            rci = (RunContextItem)((Object)iterator.next());
            out.write(rci.getImplVariable());
            if (!rci.isCreateOnDemand().booleanValue()) continue;
            onDemand = true;
        }
        if (onDemand) {
            out.write("\n");
            out.write("    MvwRunContextIF runcontext;\n");
        }
        out.write("\n");
        out.write(presenter.getCommsConstants());
        if (presenter.usesRunContext()) {
            out.write("    public " + presenter.getPresenterName() + "BaseImpl(MvwRunContextIF rc){\n");
        } else {
            out.write("    public " + presenter.getPresenterName() + "BaseImpl(){\n");
        }
        iterator = presenter.getUsesRunContextItemIterable().iterator();
        while (iterator.hasNext()) {
            rci = (RunContextItem)((Object)iterator.next());
            out.write(rci.getImplVariableAssignment());
        }
        if (presenter.usesRunContext() && onDemand) {
            out.write("\n");
            out.write("        runcontext = rc;\n");
        }
        out.write(presenter.getEventRegistration() + "\n");
        out.write("    }\n\n");
        iterator = presenter.getUsesRunContextItemIterable().iterator();
        while (iterator.hasNext()) {
            rci = (RunContextItem)((Object)iterator.next());
            out.write(rci.getOnDemandMethod());
        }
        out.write(presenter.getFireMethods());
        out.write(presenter.getCommsMethods());
        out.write(presenter.getAbstractMethods());
        out.write("}\n\n");
        out.close();
    }

    static void formatPresenterAsyncIF(String outdir, Presenter presenter) throws IOException {
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(outdir, presenter.getPresenterName() + "AsyncIF.java");
        out.write("package " + presenter.getDefinedInModule().getGenPackage() + ".generated.mvw.presenters;\n\n");
        out.write("import " + presenter.getExtendedClassImport() + ";\n\n");
        out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("public interface " + presenter.getPresenterName() + "AsyncIF {\n\n");
        out.write("    public void async" + presenter.getPresenterName() + "Ready(" + presenter.getPresenterName() + " p);\n");
        out.write("}\n");
        out.write("\n");
        out.close();
    }

    static void formatInitialPresenter(String extendir, Presenter presenter) throws IOException {
        String fn;
        File file;
        File dir;
        StringBuilder outdir = new StringBuilder(extendir);
        if (presenter.getSubpackage() != null) {
            ArrayList tokens = CheapSplitter.split((String)presenter.getSubpackage(), (char)'.', (boolean)false, (boolean)true);
            for (String token : tokens) {
                outdir.append(File.separator + token);
            }
        }
        if (!(dir = new File(outdir.toString())).exists()) {
            DebugInfo.debug((String)("Creating extended code directory:" + outdir.toString()));
            dir.mkdirs();
        }
        if (!(file = new File(fn = outdir.toString() + File.separator + presenter.getPresenterName() + ".java")).exists()) {
            BufferedWriter out = new BufferedWriter(new FileWriter(fn));
            out.write("package " + presenter.getExtendedClassPackage() + ";\n\n");
            out.write("import org.dmd.mvw.client.mvw.generated.mvw.MvwRunContextIF;\n");
            out.write("import " + presenter.getBaseImplImport() + ";\n\n");
            out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("public class " + presenter.getPresenterName() + " extends " + presenter.getPresenterName() + "BaseImpl {\n\n");
            out.write("    public " + presenter.getPresenterName() + "(MvwRunContextIF rc){\n");
            out.write("        super(rc);\n");
            out.write("    }\n");
            out.write("}\n\n");
            out.write("\n");
            out.close();
        }
    }
}

