/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.util;

import java.io.IOException;
import java.util.Iterator;
import org.dmd.mvw.tools.mvwgenerator.extended.Module;
import org.dmd.mvw.tools.mvwgenerator.extended.RunContextItem;
import org.dmd.mvw.tools.mvwgenerator.extended.WebApplication;
import org.dmd.mvw.tools.mvwgenerator.util.GenUtility;
import org.dmd.mvw.tools.mvwgenerator.util.RunContextItemCollection;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.codegen.ImportManager;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.formatting.PrintfFormat;

public class RunContextFormatter {
    public static void formatModuleRunContextInterface(String outdir, Module module, RunContextItemCollection rcic) throws IOException {
        RunContextItem rci;
        if (module.contextItemCount() == 0) {
            return;
        }
        Iterator<RunContextItem> it = null;
        String interfaceName = GenUtility.capTheName(module.getModuleName().getNameString());
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(outdir, interfaceName + "RunContextIF.java");
        String typefmt = "%-" + rcic.getLongestTypeName() + "s";
        PrintfFormat typeformat = new PrintfFormat(typefmt);
        out.write("package " + module.getGenPackage() + ".generated.mvw;\n\n");
        ImportManager manager = new ImportManager();
        it = module.getItems();
        while (it.hasNext()) {
            rci = it.next();
            rci.addInterfaceImports(manager);
        }
        out.write(manager.getFormattedImports());
        out.write("\n\n");
        out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("public interface " + interfaceName + "RunContextIF {\n\n");
        it = module.getItems();
        while (it.hasNext()) {
            rci = it.next();
            out.write(rci.getInterfaceMethod(typeformat));
        }
        out.write("}\n\n");
        out.close();
    }

    public static void formatAppRunContextInterface(String outdir, WebApplication app, RunContextItemCollection rcic) throws IOException {
        ImportManager manager = new ImportManager();
        String typefmt = "%-" + rcic.getLongestTypeName() + "s";
        PrintfFormat typeformat = new PrintfFormat(typefmt);
        String rcName = app.getAppName() + "RunContextIF";
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(outdir, rcName + ".java");
        out.write("package " + app.getDefinedInModule().getGenPackage() + ".generated.mvw;\n\n");
        for (RunContextItem rci : rcic.byOrder.values()) {
            rci.addUsageImplImports(manager, true);
        }
        out.write(manager.getFormattedImports() + "\n");
        out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("public interface " + rcName + " extends " + rcic.getAllInterfaces() + " {\n\n");
        for (RunContextItem rci : rcic.byName.values()) {
            out.write(rci.getInterfaceMethod(typeformat));
        }
        out.write("}\n\n");
        out.close();
    }

    public static void formatImplementation(String outdir, WebApplication app, RunContextItemCollection rcic) throws IOException {
        ImportManager manager = new ImportManager();
        String typefmt = "%-" + rcic.getLongestTypeName() + "s";
        PrintfFormat typeformat = new PrintfFormat(typefmt);
        String itemfmt = "%-" + rcic.getLongestItemName() + "s";
        PrintfFormat itemformat = new PrintfFormat(itemfmt);
        String rcName = app.getAppName() + "RunContext";
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(outdir, rcName + ".java");
        out.write("package " + app.getDefinedInModule().getGenPackage() + ".generated.mvw;\n\n");
        for (RunContextItem rci : rcic.byOrder.values()) {
            rci.addRunContextImplImports(manager);
        }
        out.write(manager.getFormattedImports() + "\n");
        out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("public class " + rcName + " implements " + rcName + "IF {\n\n");
        for (RunContextItem rci : rcic.byOrder.values()) {
            out.write(rci.getDefinition(typeformat));
        }
        out.write("\n");
        out.write("    public " + rcName + "(){\n\n");
        for (RunContextItem rci : rcic.byOrder.values()) {
            out.write(rci.getInstantiation(itemformat));
        }
        out.write("    }\n\n");
        for (RunContextItem rci : rcic.byName.values()) {
            out.write(rci.getImplMethod(app));
        }
        out.write("}\n\n");
        out.close();
    }
}

