/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.util;

import java.util.TreeMap;
import java.util.TreeSet;
import org.dmd.mvw.tools.mvwgenerator.extended.RunContextItem;
import org.dmd.util.exceptions.ResultException;

public class RunContextItemCollection {
    String implName;
    TreeMap<String, RunContextItem> byOrder;
    TreeMap<String, RunContextItem> byName;
    TreeSet<String> interfaces;
    int longestTypeName;
    int longestItemName;

    public RunContextItemCollection(String in) {
        this.implName = in;
        this.byOrder = new TreeMap();
        this.byName = new TreeMap();
        this.interfaces = new TreeSet();
        this.longestTypeName = 0;
        this.longestItemName = 0;
    }

    public int getLongestTypeName() {
        return this.longestTypeName;
    }

    public int getLongestItemName() {
        return this.longestItemName;
    }

    public TreeMap<String, RunContextItem> getItemsByName() {
        return this.byName;
    }

    public void addItem(RunContextItem rci) throws ResultException {
        RunContextItem existing = this.byName.get(rci.getItemName().getNameString());
        if (existing != null) {
            ResultException ex = new ResultException();
            ex.addError("Clashing run context item name: " + rci.getItemName());
            ex.result.lastResult().moreMessages("Originally defined in module: " + existing.getDefinedInModule().getModuleName());
            ex.result.lastResult().moreMessages("Redefined in module: " + rci.getDefinedInModule().getModuleName());
            throw ex;
        }
        this.byName.put(rci.getItemName().getNameString(), rci);
        this.byOrder.put(rci.getSortKey(), rci);
        this.interfaces.add(rci.getRunContextInterfaceName());
        if (rci.getItemType().length() > this.longestTypeName) {
            this.longestTypeName = rci.getItemType().length();
        }
        if (rci.getItemName().getNameString().length() > this.longestItemName) {
            this.longestItemName = rci.getItemName().getNameString().length();
        }
    }

    public RunContextItem getItem(String name) {
        return this.byName.get(name);
    }

    public String getAllInterfaces() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String i : this.interfaces) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(i);
        }
        return sb.toString();
    }
}

