/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.mvw.tools.mvwgenerator.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.dmd.dmc.types.CheapSplitter;
import org.dmd.mvw.tools.mvwgenerator.extended.RunContextItem;
import org.dmd.mvw.tools.mvwgenerator.extended.View;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.exceptions.DebugInfo;

public class ViewFormatter {
    public static void formatViewInterface(String outdir, View view) throws IOException {
        if (view.isCodeSplit().booleanValue()) {
            ViewFormatter.formatPresenterAsyncIF(outdir, view);
        }
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(outdir, view.getViewName().getNameString() + "IF.java");
        out.write("package " + view.getDefinedInModule().getGenPackage() + ".generated.mvw.views;\n\n");
        out.write(view.getInterfaceImports() + "\n");
        out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("public interface " + view.getViewName() + "IF {\n\n");
        out.write("    public interface " + view.getViewName() + "PresenterIF {\n\n");
        out.write(view.getPresenterMethods());
        out.write("    }\n\n");
        out.write(view.getViewMethods());
        out.write("}\n\n");
        out.close();
    }

    public static void formatViewBaseImpl(String outdir, View view) throws IOException {
        RunContextItem rci;
        Iterator iterator;
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(outdir, view.getViewName().getNameString() + "BaseImpl.java");
        out.write("package " + view.getDefinedInModule().getGenPackage() + ".generated.mvw.views;\n\n");
        out.write(view.getViewImplImports() + "\n");
        String otherInterfaces = "";
        if (view.isWidget().booleanValue()) {
            otherInterfaces = ", IsWidget";
        }
        out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("abstract public class " + view.getViewName() + "BaseImpl implements " + view.getViewName() + "IF" + otherInterfaces + " {\n\n");
        out.write("    protected " + view.getViewName() + "PresenterIF presenter;\n\n");
        boolean onDemand = false;
        if (view.getUsesRunContextItemHasValue()) {
            iterator = view.getUsesRunContextItemIterable().iterator();
            while (iterator.hasNext()) {
                rci = (RunContextItem)((Object)iterator.next());
                if (rci.isCreateOnDemand().booleanValue()) {
                    onDemand = true;
                    continue;
                }
                out.write(rci.getImplVariable());
            }
            out.write("\n");
        }
        if (onDemand) {
            out.write("    protected MvwRunContextIF runcontext;\n\n");
        }
        if (view.getUsesRunContextItemHasValue()) {
            out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    protected " + view.getViewName() + "BaseImpl(" + view.getViewName() + "PresenterIF p, MvwRunContextIF rc){\n");
            out.write("        presenter = p;\n\n");
            if (onDemand) {
                out.write("        runcontext = rc;\n\n");
            }
            if (view.getUsesRunContextItemHasValue()) {
                iterator = view.getUsesRunContextItemIterable().iterator();
                while (iterator.hasNext()) {
                    rci = (RunContextItem)((Object)iterator.next());
                    out.write(rci.getImplVariableAssignment());
                }
            }
            out.write("    }\n\n");
        } else {
            out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("    protected " + view.getViewName() + "BaseImpl(" + view.getViewName() + "PresenterIF p){\n");
            out.write("        presenter = p;\n");
            out.write("    }\n\n");
        }
        iterator = view.getUsesRunContextItemIterable().iterator();
        while (iterator.hasNext()) {
            rci = (RunContextItem)((Object)iterator.next());
            out.write(rci.getOnDemandMethod());
        }
        out.write(view.getViewImplMethods());
        out.write("}\n\n");
        out.close();
    }

    static void formatPresenterAsyncIF(String outdir, View view) throws IOException {
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(outdir, view.getViewName() + "AsyncIF.java");
        out.write("package " + view.getDefinedInModule().getGenPackage() + ".generated.mvw.views;\n\n");
        out.write("import " + view.getExtendedClassImport() + ";\n\n");
        out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("public interface " + view.getViewName() + "AsyncIF {\n\n");
        out.write("    public void async" + view.getViewName() + "Ready(" + view.getViewName() + " v);\n");
        out.write("}\n");
        out.write("\n");
        out.close();
    }

    static void formatInitialView(String extendir, View view) throws IOException {
        String fn;
        File file;
        File dir;
        StringBuilder outdir = new StringBuilder(extendir);
        if (view.getSubpackage() != null) {
            ArrayList tokens = CheapSplitter.split((String)view.getSubpackage(), (char)'.', (boolean)false, (boolean)true);
            for (String token : tokens) {
                outdir.append(File.separator + token);
            }
        }
        if (!(dir = new File(outdir.toString())).exists()) {
            DebugInfo.debug((String)("Creating extended code directory:" + outdir.toString()));
            dir.mkdirs();
        }
        if (!(file = new File(fn = outdir.toString() + File.separator + view.getViewName() + ".java")).exists()) {
            BufferedWriter out = new BufferedWriter(new FileWriter(fn));
            out.write("package " + view.getExtendedClassPackage() + ";\n\n");
            if (view.getUsesRunContextItemHasValue()) {
                out.write("import org.dmd.mvw.client.mvw.generated.mvw.MvwRunContextIF;\n");
            }
            out.write("import com.google.gwt.user.client.ui.Widget;\n");
            out.write("import " + view.getPresenterImport() + ";\n");
            out.write("import " + view.getBaseImplImport() + ";\n\n");
            out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            out.write("public class " + view.getViewName() + " extends " + view.getViewName() + "BaseImpl {\n\n");
            if (view.getUsesRunContextItemHasValue()) {
                out.write("    public " + view.getViewName() + "(" + view.getViewName() + "PresenterIF p, MvwRunContextIF rc){\n");
                out.write("        super(p,rc);\n");
                out.write("    }\n\n");
            } else {
                out.write("    public " + view.getViewName() + "(" + view.getViewName() + "PresenterIF p){\n");
                out.write("        super(p);\n");
                out.write("    }\n\n");
            }
            out.write("    @Override\n");
            out.write("    public Widget asWidget() {\n");
            out.write("        // TODO Auto-generated method stub\n");
            out.write("        return null;\n");
            out.write("    }\n");
            out.write("}\n\n");
            out.write("\n");
            out.close();
        }
    }
}

