/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.context;

import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.TestActor;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestCaseMetaInfo;
import com.consol.citrus.TestResult;
import com.consol.citrus.container.AfterTest;
import com.consol.citrus.container.BeforeTest;
import com.consol.citrus.container.StopTimer;
import com.consol.citrus.container.TestActionContainer;
import com.consol.citrus.endpoint.EndpointFactory;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.VariableNullValueException;
import com.consol.citrus.functions.FunctionRegistry;
import com.consol.citrus.functions.FunctionUtils;
import com.consol.citrus.message.DefaultMessageStore;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageStore;
import com.consol.citrus.report.MessageListeners;
import com.consol.citrus.report.TestActionListeners;
import com.consol.citrus.report.TestListeners;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import com.consol.citrus.util.TypeConversionUtils;
import com.consol.citrus.validation.MessageValidatorRegistry;
import com.consol.citrus.validation.interceptor.MessageConstructionInterceptors;
import com.consol.citrus.validation.matcher.ValidationMatcherRegistry;
import com.consol.citrus.variable.GlobalVariables;
import com.consol.citrus.variable.VariableUtils;
import com.consol.citrus.xml.namespace.NamespaceContextBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.javatuples.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class TestContext
implements ReferenceResolverAware {
    private static Logger log = LoggerFactory.getLogger(TestContext.class);
    protected Map<String, Object> variables;
    private GlobalVariables globalVariables;
    private MessageStore messageStore = new DefaultMessageStore();
    private FunctionRegistry functionRegistry = new FunctionRegistry();
    private EndpointFactory endpointFactory;
    private ReferenceResolver referenceResolver;
    private MessageValidatorRegistry messageValidatorRegistry = new MessageValidatorRegistry();
    private ValidationMatcherRegistry validationMatcherRegistry = new ValidationMatcherRegistry();
    private TestListeners testListeners = new TestListeners();
    private MessageListeners messageListeners = new MessageListeners();
    private MessageConstructionInterceptors messageConstructionInterceptors = new MessageConstructionInterceptors();
    private NamespaceContextBuilder namespaceContextBuilder = new NamespaceContextBuilder();
    private ApplicationContext applicationContext;
    protected Map<String, StopTimer> timers = new ConcurrentHashMap<String, StopTimer>();
    private List<CitrusRuntimeException> exceptions = new ArrayList<CitrusRuntimeException>();

    public TestContext() {
        this.variables = new ConcurrentHashMap<String, Object>();
    }

    public String getVariable(String variableExpression) {
        return this.getVariable(variableExpression, String.class);
    }

    public <T> T getVariable(String variableExpression, Class<T> type) {
        return TypeConversionUtils.convertIfNecessary(this.getVariableObject(variableExpression), type);
    }

    public Object getVariableObject(String variableExpression) {
        String objectName;
        String variableName = VariableUtils.cutOffVariablesPrefix(variableExpression);
        if (variableName.startsWith("//") && variableName.endsWith("//")) {
            return "${" + VariableUtils.cutOffVariablesEscaping(variableName) + "}";
        }
        if (this.variables.containsKey(variableName)) {
            return this.variables.get(variableName);
        }
        if (variableName.contains(".") && this.variables.containsKey(objectName = variableName.substring(0, variableName.indexOf(".")))) {
            return this.getVariable(this.variables.get(objectName), variableName.substring(variableName.indexOf(".") + 1));
        }
        throw new CitrusRuntimeException("Unknown variable '" + variableName + "'");
    }

    private Object getVariable(Object instance, String pathExpression) {
        String fieldName;
        String leftOver = null;
        if (pathExpression.contains(".")) {
            fieldName = pathExpression.substring(0, pathExpression.indexOf("."));
            leftOver = pathExpression.substring(pathExpression.indexOf(".") + 1);
        } else {
            fieldName = pathExpression;
        }
        Field field = ReflectionUtils.findField(instance.getClass(), (String)fieldName);
        if (field == null) {
            throw new CitrusRuntimeException(String.format("Failed to get variable - unknown field '%s' on type %s", fieldName, instance.getClass().getName()));
        }
        ReflectionUtils.makeAccessible((Field)field);
        Object fieldValue = ReflectionUtils.getField((Field)field, (Object)instance);
        if (StringUtils.hasText((String)leftOver)) {
            return this.getVariable(fieldValue, leftOver);
        }
        return fieldValue;
    }

    public void setVariable(String variableName, Object value) {
        if (!StringUtils.hasText((String)variableName) || VariableUtils.cutOffVariablesPrefix(variableName).length() == 0) {
            throw new CitrusRuntimeException("Can not create variable '" + variableName + "', please define proper variable name");
        }
        if (value == null) {
            throw new VariableNullValueException("Trying to set variable: " + VariableUtils.cutOffVariablesPrefix(variableName) + ", but variable value is null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Setting variable: " + VariableUtils.cutOffVariablesPrefix(variableName) + " with value: '" + value + "'");
        }
        this.variables.put(VariableUtils.cutOffVariablesPrefix(variableName), value);
    }

    public void addVariables(String[] variableNames, Object[] variableValues) {
        if (variableNames.length != variableValues.length) {
            throw new CitrusRuntimeException(String.format("Invalid context variable usage - received '%s' variables with '%s' values", variableNames.length, variableValues.length));
        }
        for (int i = 0; i < variableNames.length; ++i) {
            if (variableValues[i] == null) continue;
            this.setVariable(variableNames[i], variableValues[i]);
        }
    }

    public void addVariables(Map<String, Object> variablesToSet) {
        for (Map.Entry<String, Object> entry : variablesToSet.entrySet()) {
            if (entry.getValue() != null) {
                this.setVariable(entry.getKey(), entry.getValue());
                continue;
            }
            this.setVariable(entry.getKey(), "");
        }
    }

    public <T> Map<String, T> resolveDynamicValuesInMap(Map<String, T> map) {
        LinkedHashMap<Object, Object> target = new LinkedHashMap<Object, Object>(map.size());
        for (Map.Entry<String, T> entry : map.entrySet()) {
            KeyValue<String, T> adaptedEntry = this.resolveDynamicContent(entry.getKey(), entry.getValue());
            target.put(adaptedEntry.getKey(), adaptedEntry.getValue());
        }
        return target;
    }

    private <K, V> KeyValue<K, V> resolveDynamicContent(K key, V value) {
        K adaptedKey = this.resolveDynamicContentIfRequired(key);
        V adaptedValue = this.resolveDynamicContentIfRequired(value);
        return KeyValue.with(adaptedKey, adaptedValue);
    }

    public <T> List<T> resolveDynamicValuesInList(List<T> list) {
        ArrayList<String> variableFreeList = new ArrayList<String>(list.size());
        for (T value : list) {
            if (!(value instanceof String)) continue;
            variableFreeList.add(this.replaceDynamicContentInString((String)value));
        }
        return variableFreeList;
    }

    private <V> V resolveDynamicContentIfRequired(V value) {
        Object adaptedValue = value instanceof String ? this.replaceDynamicContentInString((String)value) : value;
        return adaptedValue;
    }

    public <T> T[] resolveDynamicValuesInArray(T[] array) {
        return this.resolveDynamicValuesInList(Arrays.asList(array)).toArray(Arrays.copyOf(array, array.length));
    }

    public void clear() {
        this.variables.clear();
        this.variables.putAll(this.globalVariables.getVariables());
    }

    public boolean hasVariables() {
        return !CollectionUtils.isEmpty(this.variables);
    }

    public String replaceDynamicContentInString(String str) {
        return this.replaceDynamicContentInString(str, false);
    }

    public String replaceDynamicContentInString(String str, boolean enableQuoting) {
        String result = null;
        if (str != null) {
            result = VariableUtils.replaceVariablesInString(str, this, enableQuoting);
            result = FunctionUtils.replaceFunctionsInString(result, this, enableQuoting);
        }
        return result;
    }

    public String resolveDynamicValue(String expression) {
        if (VariableUtils.isVariableName(expression)) {
            return this.getVariable(expression);
        }
        if (this.functionRegistry.isFunction(expression)) {
            return FunctionUtils.resolveFunction(expression, this);
        }
        return expression;
    }

    public CitrusRuntimeException handleError(String testName, String packageName, String message, Exception cause) {
        EmptyTestCase dummyTest = new EmptyTestCase(testName, packageName);
        CitrusRuntimeException exception = new CitrusRuntimeException(message, cause);
        this.testListeners.onTestStart(dummyTest);
        this.testListeners.onTestFailure(dummyTest, exception);
        this.testListeners.onTestFinish(dummyTest);
        return exception;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setGlobalVariables(GlobalVariables globalVariables) {
        this.globalVariables = new GlobalVariables();
        for (Map.Entry<String, Object> entry : globalVariables.getVariables().entrySet()) {
            KeyValue<String, Object> adaptedEntry = this.resolveDynamicContent(entry.getKey(), entry.getValue());
            this.variables.put((String)adaptedEntry.getKey(), adaptedEntry.getValue());
            this.globalVariables.getVariables().put((String)adaptedEntry.getKey(), adaptedEntry.getValue());
        }
    }

    public Map<String, Object> getGlobalVariables() {
        return this.globalVariables.getVariables();
    }

    public void setMessageStore(MessageStore messageStore) {
        this.messageStore = messageStore;
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    public FunctionRegistry getFunctionRegistry() {
        return this.functionRegistry;
    }

    public void setFunctionRegistry(FunctionRegistry functionRegistry) {
        this.functionRegistry = functionRegistry;
    }

    public void setMessageValidatorRegistry(MessageValidatorRegistry messageValidatorRegistry) {
        this.messageValidatorRegistry = messageValidatorRegistry;
    }

    public MessageValidatorRegistry getMessageValidatorRegistry() {
        return this.messageValidatorRegistry;
    }

    public ValidationMatcherRegistry getValidationMatcherRegistry() {
        return this.validationMatcherRegistry;
    }

    public void setValidationMatcherRegistry(ValidationMatcherRegistry validationMatcherRegistry) {
        this.validationMatcherRegistry = validationMatcherRegistry;
    }

    public MessageListeners getMessageListeners() {
        return this.messageListeners;
    }

    public void setMessageListeners(MessageListeners messageListeners) {
        this.messageListeners = messageListeners;
    }

    public TestListeners getTestListeners() {
        return this.testListeners;
    }

    public void setTestListeners(TestListeners testListeners) {
        this.testListeners = testListeners;
    }

    public MessageConstructionInterceptors getMessageConstructionInterceptors() {
        return this.messageConstructionInterceptors;
    }

    public void setMessageConstructionInterceptors(MessageConstructionInterceptors messageConstructionInterceptors) {
        this.messageConstructionInterceptors = messageConstructionInterceptors;
    }

    public EndpointFactory getEndpointFactory() {
        return this.endpointFactory;
    }

    public void setEndpointFactory(EndpointFactory endpointFactory) {
        this.endpointFactory = endpointFactory;
    }

    public ReferenceResolver getReferenceResolver() {
        return this.referenceResolver;
    }

    @Override
    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    public void setNamespaceContextBuilder(NamespaceContextBuilder namespaceContextBuilder) {
        this.namespaceContextBuilder = namespaceContextBuilder;
    }

    public NamespaceContextBuilder getNamespaceContextBuilder() {
        return this.namespaceContextBuilder;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void onInboundMessage(Message receivedMessage) {
        if (this.messageListeners != null && !this.messageListeners.isEmpty()) {
            this.messageListeners.onInboundMessage(receivedMessage, this);
        } else if (log.isDebugEnabled()) {
            log.debug("Received message:" + System.getProperty("line.separator") + (receivedMessage != null ? receivedMessage.toString() : ""));
        }
    }

    public void onOutboundMessage(Message message) {
        if (this.messageListeners != null && !this.messageListeners.isEmpty()) {
            this.messageListeners.onOutboundMessage(message, this);
        } else if (log.isDebugEnabled()) {
            log.debug("Sent message:" + System.getProperty("line.separator") + message.toString());
        }
    }

    public void registerTimer(String timerId, StopTimer timer) {
        if (this.timers.containsKey(timerId)) {
            throw new CitrusRuntimeException("Timer already registered with this id");
        }
        this.timers.put(timerId, timer);
    }

    public boolean stopTimer(String timerId) {
        StopTimer timer = this.timers.get(timerId);
        if (timer != null) {
            timer.stopTimer();
            return true;
        }
        return false;
    }

    public void stopTimers() {
        for (String timerId : this.timers.keySet()) {
            this.stopTimer(timerId);
        }
    }

    public void addException(CitrusRuntimeException exception) {
        this.exceptions.add(exception);
    }

    public List<CitrusRuntimeException> getExceptions() {
        return this.exceptions;
    }

    public boolean hasExceptions() {
        return !CollectionUtils.isEmpty(this.getExceptions());
    }

    public boolean isSuccess(TestResult testResult) {
        return !this.hasExceptions() && Optional.ofNullable(testResult).map(TestResult::isSuccess).orElse(false) != false;
    }

    private static class EmptyTestCase
    implements TestCase {
        private final String testName;
        private final String packageName;

        public EmptyTestCase(String testName, String packageName) {
            this.testName = testName;
            this.packageName = packageName;
        }

        @Override
        public String getName() {
            return this.testName;
        }

        @Override
        public String getPackageName() {
            return this.packageName;
        }

        @Override
        public Map<String, Object> getVariableDefinitions() {
            return Collections.emptyMap();
        }

        @Override
        public TestActionContainer setActions(List<TestAction> actions) {
            return this;
        }

        @Override
        public List<TestAction> getActions() {
            return Collections.emptyList();
        }

        @Override
        public long getActionCount() {
            return 0L;
        }

        @Override
        public TestActionContainer addTestActions(TestAction ... action) {
            return this;
        }

        @Override
        public TestActionContainer addTestAction(TestAction action) {
            return this;
        }

        @Override
        public int getActionIndex(TestAction action) {
            return 0;
        }

        @Override
        public TestAction getActiveAction() {
            return null;
        }

        @Override
        public List<TestAction> getExecutedActions() {
            return Collections.emptyList();
        }

        @Override
        public TestAction getTestAction(int index) {
            return null;
        }

        @Override
        public TestAction setName(String name) {
            return this;
        }

        @Override
        public String getDescription() {
            return "Empty test";
        }

        @Override
        public TestAction setDescription(String description) {
            return this;
        }

        @Override
        public boolean isDisabled(TestContext context) {
            return false;
        }

        @Override
        public TestActor getActor() {
            return null;
        }

        @Override
        public TestAction setActor(TestActor actor) {
            return this;
        }

        @Override
        public void execute(TestContext context) {
        }

        @Override
        public void start(TestContext context) {
        }

        @Override
        public void executeAction(TestAction action, TestContext context) {
        }

        @Override
        public void finish(TestContext context) {
        }

        @Override
        public void setTestResult(TestResult testResult) {
        }

        @Override
        public void addFinalAction(TestActionBuilder<?> action) {
        }

        @Override
        public void setTestActionListeners(TestActionListeners testActionListeners) {
        }

        @Override
        public void setBeforeTest(List<BeforeTest> beforeTest) {
        }

        @Override
        public void setAfterTest(List<AfterTest> afterTest) {
        }

        @Override
        public void setPackageName(String packageName) {
        }

        @Override
        public void setActiveAction(TestAction action) {
        }

        @Override
        public void setTestClass(Class<?> type) {
        }

        @Override
        public TestCaseMetaInfo getMetaInfo() {
            return new TestCaseMetaInfo();
        }

        @Override
        public Class<?> getTestClass() {
            return this.getClass();
        }
    }
}

