/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.context;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.DefaultEndpointFactory;
import com.consol.citrus.endpoint.EndpointFactory;
import com.consol.citrus.functions.FunctionRegistry;
import com.consol.citrus.report.MessageListeners;
import com.consol.citrus.report.TestListeners;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import com.consol.citrus.spi.SimpleReferenceResolver;
import com.consol.citrus.validation.MessageValidatorRegistry;
import com.consol.citrus.validation.interceptor.MessageConstructionInterceptors;
import com.consol.citrus.validation.matcher.ValidationMatcherRegistry;
import com.consol.citrus.variable.GlobalVariables;
import com.consol.citrus.xml.namespace.NamespaceContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestContextFactory
implements ReferenceResolverAware {
    private FunctionRegistry functionRegistry;
    private ValidationMatcherRegistry validationMatcherRegistry;
    private GlobalVariables globalVariables = new GlobalVariables();
    private MessageValidatorRegistry messageValidatorRegistry;
    private TestListeners testListeners;
    private MessageListeners messageListeners;
    private EndpointFactory endpointFactory;
    private ReferenceResolver referenceResolver;
    private MessageConstructionInterceptors messageConstructionInterceptors;
    private NamespaceContextBuilder namespaceContextBuilder;
    private static Logger log = LoggerFactory.getLogger(TestContextFactory.class);

    public static TestContextFactory newInstance() {
        TestContextFactory factory = new TestContextFactory();
        factory.setFunctionRegistry(new FunctionRegistry());
        factory.setValidationMatcherRegistry(new ValidationMatcherRegistry());
        factory.setGlobalVariables(new GlobalVariables());
        factory.setMessageValidatorRegistry(new MessageValidatorRegistry());
        factory.setTestListeners(new TestListeners());
        factory.setMessageListeners(new MessageListeners());
        factory.setMessageConstructionInterceptors(new MessageConstructionInterceptors());
        factory.setEndpointFactory(new DefaultEndpointFactory());
        factory.setReferenceResolver(new SimpleReferenceResolver());
        factory.setNamespaceContextBuilder(new NamespaceContextBuilder());
        return factory;
    }

    public TestContext getObject() {
        TestContext context = new TestContext();
        context.setFunctionRegistry(this.functionRegistry);
        context.setValidationMatcherRegistry(this.validationMatcherRegistry);
        context.setGlobalVariables(this.globalVariables);
        context.setMessageValidatorRegistry(this.messageValidatorRegistry);
        context.setTestListeners(this.testListeners);
        context.setMessageListeners(this.messageListeners);
        context.setMessageConstructionInterceptors(this.messageConstructionInterceptors);
        context.setEndpointFactory(this.endpointFactory);
        context.setReferenceResolver(this.referenceResolver);
        if (this.namespaceContextBuilder != null) {
            context.setNamespaceContextBuilder(this.namespaceContextBuilder);
        }
        if (log.isDebugEnabled()) {
            log.debug("Created new test context - using global variables: '" + context.getGlobalVariables() + "'");
        }
        return context;
    }

    public void setFunctionRegistry(FunctionRegistry functionRegistry) {
        this.functionRegistry = functionRegistry;
    }

    public FunctionRegistry getFunctionRegistry() {
        return this.functionRegistry;
    }

    public void setValidationMatcherRegistry(ValidationMatcherRegistry validationMatcherRegistry) {
        this.validationMatcherRegistry = validationMatcherRegistry;
    }

    public ValidationMatcherRegistry getValidationMatcherRegistry() {
        return this.validationMatcherRegistry;
    }

    public void setGlobalVariables(GlobalVariables globalVariables) {
        this.globalVariables = globalVariables;
    }

    public GlobalVariables getGlobalVariables() {
        return this.globalVariables;
    }

    public EndpointFactory getEndpointFactory() {
        return this.endpointFactory;
    }

    public void setEndpointFactory(EndpointFactory endpointFactory) {
        this.endpointFactory = endpointFactory;
    }

    public ReferenceResolver getReferenceResolver() {
        return this.referenceResolver;
    }

    @Override
    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    public void setNamespaceContextBuilder(NamespaceContextBuilder namespaceContextBuilder) {
        this.namespaceContextBuilder = namespaceContextBuilder;
    }

    public NamespaceContextBuilder getNamespaceContextBuilder() {
        return this.namespaceContextBuilder;
    }

    public void setTestListeners(TestListeners testListeners) {
        this.testListeners = testListeners;
    }

    public TestListeners getTestListeners() {
        return this.testListeners;
    }

    public void setMessageValidatorRegistry(MessageValidatorRegistry messageValidatorRegistry) {
        this.messageValidatorRegistry = messageValidatorRegistry;
    }

    public MessageValidatorRegistry getMessageValidatorRegistry() {
        return this.messageValidatorRegistry;
    }

    public void setMessageListeners(MessageListeners messageListeners) {
        this.messageListeners = messageListeners;
    }

    public MessageListeners getMessageListeners() {
        return this.messageListeners;
    }

    public void setMessageConstructionInterceptors(MessageConstructionInterceptors messageConstructionInterceptors) {
        this.messageConstructionInterceptors = messageConstructionInterceptors;
    }

    public MessageConstructionInterceptors getMessageConstructionInterceptors() {
        return this.messageConstructionInterceptors;
    }
}

