/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.endpoint;

import com.consol.citrus.annotations.CitrusEndpointConfig;
import com.consol.citrus.config.annotation.AnnotationConfigParser;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.endpoint.EndpointComponent;
import com.consol.citrus.endpoint.EndpointFactory;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.spi.ReferenceResolver;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class DefaultEndpointFactory
implements EndpointFactory {
    private static Logger log = LoggerFactory.getLogger(DefaultEndpointFactory.class);
    private static Properties endpointComponentProperties;
    private static Properties endpointParserProperties;
    private Map<String, Endpoint> endpointCache = new ConcurrentHashMap<String, Endpoint>();

    @Override
    public Endpoint create(String endpointName, Annotation endpointConfig, TestContext context) {
        String qualifier = endpointConfig.annotationType().getAnnotation(CitrusEndpointConfig.class).qualifier();
        AnnotationConfigParser<Annotation, ? extends Endpoint> parser = this.getAnnotationParser(context.getReferenceResolver()).get(qualifier);
        if (parser == null) {
            parser = this.resolveDefaultAnnotationParser(qualifier, context.getReferenceResolver());
        }
        if (parser == null) {
            throw new CitrusRuntimeException(String.format("Unable to create endpoint annotation parser with name '%s'", qualifier));
        }
        Object endpoint = parser.parse(endpointConfig);
        endpoint.setName(endpointName);
        return endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint create(String uri, TestContext context) {
        String endpointUri = context.replaceDynamicContentInString(uri);
        if (!endpointUri.contains(":")) {
            return context.getReferenceResolver().resolve(endpointUri, Endpoint.class);
        }
        StringTokenizer tok = new StringTokenizer(endpointUri, ":");
        if (tok.countTokens() < 2) {
            throw new CitrusRuntimeException(String.format("Invalid endpoint uri '%s'", endpointUri));
        }
        String componentName = tok.nextToken();
        EndpointComponent component = this.getEndpointComponents(context.getReferenceResolver()).get(componentName);
        if (component == null) {
            component = this.resolveDefaultComponent(componentName);
        }
        if (component == null) {
            throw new CitrusRuntimeException(String.format("Unable to create endpoint component with name '%s'", componentName));
        }
        Map<String, String> parameters = component.getParameters(endpointUri);
        String cachedEndpointName = parameters.containsKey("endpointName") ? parameters.remove("endpointName") : endpointUri;
        Map<String, Endpoint> map = this.endpointCache;
        synchronized (map) {
            if (this.endpointCache.containsKey(cachedEndpointName)) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Found cached endpoint for uri '%s'", cachedEndpointName));
                }
                return this.endpointCache.get(cachedEndpointName);
            }
            Endpoint endpoint = component.createEndpoint(endpointUri, context);
            this.endpointCache.put(cachedEndpointName, endpoint);
            return endpoint;
        }
    }

    private Map<String, EndpointComponent> getEndpointComponents(ReferenceResolver referenceResolver) {
        return referenceResolver.resolveAll(EndpointComponent.class);
    }

    private EndpointComponent resolveDefaultComponent(String componentName) {
        String endpointComponentClassName = endpointComponentProperties.getProperty(componentName);
        try {
            if (endpointComponentClassName != null) {
                Class<?> endpointComponentClass = Class.forName(endpointComponentClassName);
                EndpointComponent endpointComponent = (EndpointComponent)endpointComponentClass.newInstance();
                endpointComponent.setName(componentName);
                return endpointComponent;
            }
        }
        catch (ClassNotFoundException e) {
            log.warn(String.format("Unable to find default Citrus endpoint component '%s' in classpath", endpointComponentClassName), (Throwable)e);
        }
        catch (InstantiationException e) {
            log.warn(String.format("Unable to instantiate Citrus endpoint component '%s'", endpointComponentClassName), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warn(String.format("Unable to access Citrus endpoint component '%s'", endpointComponentClassName), (Throwable)e);
        }
        return null;
    }

    private Map<String, AnnotationConfigParser> getAnnotationParser(ReferenceResolver referenceResolver) {
        return referenceResolver.resolveAll(AnnotationConfigParser.class);
    }

    private AnnotationConfigParser<Annotation, ? extends Endpoint> resolveDefaultAnnotationParser(String qualifier, ReferenceResolver referenceResolver) {
        String annotationParserClassName = endpointParserProperties.getProperty(qualifier);
        try {
            if (annotationParserClassName != null) {
                Class<?> annotationParserClass = Class.forName(annotationParserClassName);
                return (AnnotationConfigParser)annotationParserClass.getConstructor(ReferenceResolver.class).newInstance(referenceResolver);
            }
        }
        catch (ClassNotFoundException e) {
            log.warn(String.format("Unable to find default Citrus endpoint parser '%s' in classpath", annotationParserClassName), (Throwable)e);
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.warn(String.format("Unable to instantiate Citrus endpoint parser '%s'", annotationParserClassName), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warn(String.format("Unable to access Citrus endpoint parser '%s'", annotationParserClassName), (Throwable)e);
        }
        return null;
    }

    static {
        try {
            endpointComponentProperties = PropertiesLoaderUtils.loadProperties((Resource)new ClassPathResource("com/consol/citrus/endpoint/endpoint.components"));
        }
        catch (IOException e) {
            log.warn("Unable to laod default endpoint components from resource '%s'", (Throwable)e);
        }
        try {
            endpointParserProperties = PropertiesLoaderUtils.loadProperties((Resource)new ClassPathResource("com/consol/citrus/endpoint/endpoint.parser"));
        }
        catch (IOException e) {
            log.warn("Unable to laod default endpoint annotation parsers from resource '%s'", (Throwable)e);
        }
    }
}

