/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.functions;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.NoSuchFunctionLibraryException;
import com.consol.citrus.functions.FunctionLibrary;
import java.util.ArrayList;
import java.util.List;

public class FunctionRegistry {
    private List<FunctionLibrary> functionLibraries = new ArrayList<FunctionLibrary>();

    public boolean isFunction(String variableExpression) {
        if (variableExpression == null || variableExpression.length() == 0) {
            return false;
        }
        for (FunctionLibrary lib : this.functionLibraries) {
            if (!variableExpression.startsWith(lib.getPrefix())) continue;
            return true;
        }
        return false;
    }

    public FunctionLibrary getLibraryForPrefix(String functionPrefix) {
        for (FunctionLibrary functionLibrary : this.functionLibraries) {
            if (!functionLibrary.getPrefix().equals(functionPrefix)) continue;
            return functionLibrary;
        }
        throw new NoSuchFunctionLibraryException("Can not find function library for prefix " + functionPrefix);
    }

    public void addFunctionLibrary(FunctionLibrary functionLibrary) {
        boolean prefixAlreadyUsed = this.functionLibraries.stream().anyMatch(lib -> lib.getPrefix().equals(functionLibrary.getPrefix()));
        if (prefixAlreadyUsed) {
            throw new CitrusRuntimeException(String.format("Function library prefix '%s' is already bound to another instance. Please choose another prefix.", functionLibrary.getPrefix()));
        }
        this.functionLibraries.add(functionLibrary);
    }

    public void setFunctionLibraries(List<FunctionLibrary> functionLibraries) {
        this.functionLibraries = functionLibraries;
    }

    public List<FunctionLibrary> getFunctionLibraries() {
        return this.functionLibraries;
    }
}

