/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.spi;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.spi.TypeResolver;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ResourcePathTypeResolver
implements TypeResolver {
    private static Logger log = LoggerFactory.getLogger(ResourcePathTypeResolver.class);
    private final String resourceBasePath;

    public ResourcePathTypeResolver() {
        this("META-INF");
    }

    public ResourcePathTypeResolver(String resourceBasePath) {
        this.resourceBasePath = resourceBasePath.endsWith("/") ? resourceBasePath.substring(0, resourceBasePath.length() - 1) : resourceBasePath;
    }

    @Override
    public String resolveProperty(String resourcePath, String property) {
        String path = this.getFullResourcePath(resourcePath);
        InputStream in = ResourcePathTypeResolver.class.getClassLoader().getResourceAsStream(path);
        if (in == null) {
            throw new CitrusRuntimeException(String.format("Failed to locate resource path '%s'", path));
        }
        try {
            Properties config = new Properties();
            config.load(in);
            return config.getProperty(property);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(String.format("Unable to load properties from resource path configuration at '%s'", path), e);
        }
    }

    @Override
    public <T> T resolve(String resourcePath, String property) {
        String type = this.resolveProperty(resourcePath, property);
        try {
            return (T)Class.forName(type).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CitrusRuntimeException(String.format("Failed to resolve classpath resource of type '%s'", type), e);
        }
    }

    @Override
    public <T> Map<String, T> resolveAll(String resourcePath, String property, String keyProperty) {
        HashMap resources = new HashMap();
        String path = this.getFullResourcePath(resourcePath);
        try {
            Stream.of(new PathMatchingResourcePatternResolver().getResources("classpath*:" + path + "/*")).forEach(file -> {
                Optional<String> resourceName = Optional.ofNullable(file.getFilename());
                if (resourceName.isPresent()) {
                    Object resource = this.resolve(path + "/" + resourceName.get());
                    if (keyProperty != null) {
                        resources.put(this.resolveProperty(path + "/" + resourceName.get(), keyProperty), resource);
                    } else {
                        resources.put(resourceName.get(), resource);
                    }
                } else {
                    log.warn(String.format("Skip unsupported resource '%s' for resource lookup", file));
                }
            });
        }
        catch (IOException e) {
            log.warn(String.format("Failed to resolve resources in '%s'", path), (Throwable)e);
        }
        return resources;
    }

    private String getFullResourcePath(String resourcePath) {
        if (resourcePath == null || resourcePath.length() == 0) {
            return this.resourceBasePath;
        }
        if (!resourcePath.startsWith(this.resourceBasePath)) {
            return this.resourceBasePath + "/" + resourcePath;
        }
        return resourcePath;
    }
}

