/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.util;

import com.consol.citrus.CitrusSettings;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.core.io.InputStreamSource;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.xml.transform.StringSource;
import org.w3c.dom.Node;

public abstract class TypeConversionUtils {
    private static Logger log = LoggerFactory.getLogger(TypeConversionUtils.class);

    private TypeConversionUtils() {
    }

    public static <T> T convertIfNecessary(Object target, Class<T> type) {
        if (type.isInstance(target)) {
            return type.cast(target);
        }
        if (Source.class.isAssignableFrom(type)) {
            if (target.getClass().isAssignableFrom(String.class)) {
                return (T)new StringSource(String.valueOf(target));
            }
            if (target.getClass().isAssignableFrom(Node.class)) {
                return (T)new DOMSource((Node)target);
            }
            if (target.getClass().isAssignableFrom(InputStreamSource.class)) {
                try {
                    return (T)new StreamSource(((InputStreamSource)target).getInputStream());
                }
                catch (IOException e) {
                    log.warn("Failed to create stream source from object", (Throwable)e);
                }
            }
        }
        if (MultiValueMap.class.isAssignableFrom(type)) {
            String mapString = String.valueOf(target);
            Properties props = new Properties();
            try {
                props.load(new StringReader(mapString.substring(1, mapString.length() - 1).replaceAll("\\]\\s*", "]\n")));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to reconstruct object of type map", e);
            }
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String arrayString = String.valueOf(entry.getValue()).replaceAll("^\\[", "").replaceAll("\\]$", "").replaceAll(",\\s", ",");
                map.add((Object)entry.getKey().toString(), (Object)StringUtils.commaDelimitedListToStringArray((String)String.valueOf(arrayString)));
            }
            return (T)map;
        }
        if (Map.class.isAssignableFrom(type)) {
            String mapString = String.valueOf(target);
            Properties props = new Properties();
            try {
                props.load(new StringReader(mapString.substring(1, mapString.length() - 1).replaceAll(",\\s*", "\n")));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to reconstruct object of type map", e);
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                map.put(entry.getKey().toString(), entry.getValue());
            }
            return (T)map;
        }
        if (String[].class.isAssignableFrom(type)) {
            String arrayString = String.valueOf(target).replaceAll("^\\[", "").replaceAll("\\]$", "").replaceAll(",\\s", ",");
            return (T)StringUtils.commaDelimitedListToStringArray((String)String.valueOf(arrayString));
        }
        if (List.class.isAssignableFrom(type)) {
            String listString = String.valueOf(target).replaceAll("^\\[", "").replaceAll("\\]$", "").replaceAll(",\\s", ",");
            return (T)Arrays.asList(StringUtils.commaDelimitedListToStringArray((String)String.valueOf(listString)));
        }
        if (byte[].class.isAssignableFrom(type)) {
            if (target instanceof String) {
                try {
                    return (T)String.valueOf(target).getBytes(CitrusSettings.CITRUS_FILE_ENCODING);
                }
                catch (UnsupportedEncodingException e) {
                    return (T)String.valueOf(target).getBytes();
                }
            }
            if (target instanceof ByteBuffer) {
                return (T)((ByteBuffer)target).array();
            }
            if (target instanceof ByteArrayInputStream) {
                try {
                    return (T)StreamUtils.copyToByteArray((InputStream)((ByteArrayInputStream)target));
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to convert input stream to byte[]");
                }
            }
        }
        if (InputStream.class.isAssignableFrom(type)) {
            if (target instanceof InputStream) {
                return (T)target;
            }
            if (target instanceof byte[]) {
                return (T)new ByteArrayInputStream((byte[])target);
            }
            if (target instanceof String) {
                try {
                    return (T)new ByteArrayInputStream(String.valueOf(target).getBytes(CitrusSettings.CITRUS_FILE_ENCODING));
                }
                catch (UnsupportedEncodingException e) {
                    return (T)new ByteArrayInputStream(String.valueOf(target).getBytes());
                }
            }
            try {
                return (T)new ByteArrayInputStream(target.toString().getBytes(CitrusSettings.CITRUS_FILE_ENCODING));
            }
            catch (UnsupportedEncodingException e) {
                return (T)new ByteArrayInputStream(target.toString().getBytes());
            }
        }
        if (type.equals(String.class)) {
            if (ByteBuffer.class.isAssignableFrom(target.getClass())) {
                return (T)new String(((ByteBuffer)target).array());
            }
            if (byte[].class.isAssignableFrom(target.getClass())) {
                return (T)Arrays.toString((byte[])target);
            }
        }
        try {
            return (T)new SimpleTypeConverter().convertIfNecessary(target, type);
        }
        catch (ConversionNotSupportedException e) {
            if (String.class.equals(type)) {
                log.warn(String.format("Using object toString representation: %s", e.getMessage()));
                return (T)target.toString();
            }
            throw e;
        }
    }

    public static <T> T convertStringToType(String value, Class<T> type) {
        if (type.isAssignableFrom(String.class)) {
            return (T)value;
        }
        if (type.isAssignableFrom(Integer.TYPE) || type.isAssignableFrom(Integer.class)) {
            return (T)Integer.valueOf(value);
        }
        if (type.isAssignableFrom(Short.TYPE) || type.isAssignableFrom(Short.class)) {
            return (T)Short.valueOf(value);
        }
        if (type.isAssignableFrom(Byte.TYPE) || type.isAssignableFrom(Byte.class)) {
            return (T)Byte.valueOf(value);
        }
        if (type.isAssignableFrom(Long.TYPE) || type.isAssignableFrom(Long.class)) {
            return (T)Long.valueOf(value);
        }
        if (type.isAssignableFrom(Boolean.TYPE) || type.isAssignableFrom(Boolean.class)) {
            return (T)Boolean.valueOf(value);
        }
        if (type.isAssignableFrom(Float.TYPE) || type.isAssignableFrom(Float.class)) {
            return (T)Float.valueOf(value);
        }
        if (type.isAssignableFrom(Double.TYPE) || type.isAssignableFrom(Double.class)) {
            return (T)Double.valueOf(value);
        }
        throw new CitrusRuntimeException(String.format("Unable to convert '%s' to required type '%s'", value, type.getName()));
    }

    public static <T> T convertStringToType(String value, Class<T> type, TestContext context) {
        try {
            return TypeConversionUtils.convertStringToType(value, type);
        }
        catch (CitrusRuntimeException e) {
            T bean;
            if (context.getReferenceResolver() != null && context.getReferenceResolver().isResolvable(value) && type.isAssignableFrom((bean = context.getReferenceResolver().resolve(value, type)).getClass())) {
                return bean;
            }
            throw new CitrusRuntimeException(String.format("Unable to convert '%s' to required type '%s' - also no bean of required type available in application context", value, type.getName()), e.getCause());
        }
    }
}

