/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.spi.ResourcePathTypeResolver;
import com.consol.citrus.spi.TypeResolver;
import com.consol.citrus.validation.MessageValidator;
import com.consol.citrus.validation.context.HeaderValidationContext;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface HeaderValidator {
    public static final Logger LOG = LoggerFactory.getLogger(MessageValidator.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/header/validator";
    public static final TypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/header/validator");

    public static Map<String, HeaderValidator> lookup() {
        Map<String, HeaderValidator> validators = TYPE_RESOLVER.resolveAll("", "type", "name");
        if (LOG.isDebugEnabled()) {
            validators.forEach((k, v) -> LOG.debug(String.format("Found header validator '%s' as %s", k, v.getClass())));
        }
        return validators;
    }

    public static Optional<HeaderValidator> lookup(String validator) {
        try {
            HeaderValidator instance = (HeaderValidator)TYPE_RESOLVER.resolve(validator);
            return Optional.of(instance);
        }
        catch (CitrusRuntimeException e) {
            LOG.warn(String.format("Failed to resolve header validator from resource '%s/%s'", RESOURCE_PATH, validator));
            return Optional.empty();
        }
    }

    public boolean supports(String var1, Class<?> var2);

    public void validateHeader(String var1, Object var2, Object var3, TestContext var4, HeaderValidationContext var5);
}

