/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.NoSuchMessageValidatorException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.validation.MessageValidator;
import com.consol.citrus.validation.context.ValidationContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class MessageValidatorRegistry {
    private static Logger log = LoggerFactory.getLogger(MessageValidatorRegistry.class);
    public static final String BEAN_NAME = "citrusMessageValidatorRegistry";
    private Map<String, MessageValidator<? extends ValidationContext>> messageValidators = new LinkedHashMap<String, MessageValidator<? extends ValidationContext>>();
    private MessageValidator<? extends ValidationContext> defaultMessageHeaderValidator;

    public List<MessageValidator<? extends ValidationContext>> findMessageValidators(String messageType, Message message) {
        List<MessageValidator<? extends ValidationContext>> matchingValidators = new ArrayList<MessageValidator<? extends ValidationContext>>();
        for (MessageValidator<? extends ValidationContext> validator : this.messageValidators.values()) {
            if (!validator.supportsMessageType(messageType, message)) continue;
            matchingValidators.add(validator);
        }
        if ((matchingValidators.isEmpty() || matchingValidators.stream().allMatch(this::isDefaultMessageHeaderValidator)) && message.getPayload() instanceof String && StringUtils.hasText((String)message.getPayload(String.class))) {
            String payload = message.getPayload(String.class).trim();
            if (payload.startsWith("<") && !messageType.equals(MessageType.XML.name())) {
                matchingValidators = this.findFallbackMessageValidators(MessageType.XML.name(), message);
            } else if ((payload.startsWith("{") || payload.startsWith("[")) && !messageType.equals(MessageType.JSON.name())) {
                matchingValidators = this.findFallbackMessageValidators(MessageType.JSON.name(), message);
            } else if (!messageType.equals(MessageType.PLAINTEXT.name())) {
                matchingValidators = this.findFallbackMessageValidators(MessageType.PLAINTEXT.name(), message);
            }
        }
        if (matchingValidators.isEmpty() || matchingValidators.stream().allMatch(this::isDefaultMessageHeaderValidator)) {
            throw new CitrusRuntimeException("Could not find proper message validator for message type '" + messageType + "', please define a capable message validator for this message type");
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Found %s message validators for message type: %s", matchingValidators.size(), messageType));
        }
        return matchingValidators;
    }

    private boolean isDefaultMessageHeaderValidator(MessageValidator<? extends ValidationContext> messageValidator) {
        if (this.defaultMessageHeaderValidator == null) {
            this.defaultMessageHeaderValidator = MessageValidator.lookup("header").orElseThrow(() -> new CitrusRuntimeException("Unable to locate default message header validator"));
        }
        return this.defaultMessageHeaderValidator.getClass().isAssignableFrom(messageValidator.getClass());
    }

    private List<MessageValidator<? extends ValidationContext>> findFallbackMessageValidators(String messageType, Message message) {
        ArrayList<MessageValidator<? extends ValidationContext>> matchingValidators = new ArrayList<MessageValidator<? extends ValidationContext>>();
        for (MessageValidator<? extends ValidationContext> validator : this.messageValidators.values()) {
            if (!validator.supportsMessageType(messageType, message)) continue;
            matchingValidators.add(validator);
        }
        return matchingValidators;
    }

    public Optional<MessageValidator<? extends ValidationContext>> findMessageValidator(String name) {
        if (this.messageValidators.containsKey(name)) {
            return Optional.of(this.messageValidators.get(name));
        }
        return Optional.empty();
    }

    public MessageValidator<? extends ValidationContext> getMessageValidator(String name) {
        if (this.messageValidators.containsKey(name)) {
            return this.messageValidators.get(name);
        }
        throw new NoSuchMessageValidatorException(String.format("Unable to find message validator with name '%s'", name));
    }

    public void addMessageValidator(String name, MessageValidator<? extends ValidationContext> messageValidator) {
        if (this.messageValidators.containsKey(name)) {
            log.warn(String.format("Overwriting message validator '%s' in registry", name));
        }
        this.messageValidators.put(name, messageValidator);
    }

    public void setMessageValidators(Map<String, MessageValidator<? extends ValidationContext>> messageValidators) {
        this.messageValidators = messageValidators;
    }

    public Map<String, MessageValidator<? extends ValidationContext>> getMessageValidators() {
        return this.messageValidators;
    }

    public MessageValidator<? extends ValidationContext> getDefaultMessageHeaderValidator() {
        return this.messageValidators.values().stream().filter(this::isDefaultMessageHeaderValidator).findFirst().orElse(this.defaultMessageHeaderValidator);
    }
}

