/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.spi.ResourcePathTypeResolver;
import com.consol.citrus.spi.TypeResolver;
import com.consol.citrus.validation.MessageValidator;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ValueMatcher {
    public static final Logger LOG = LoggerFactory.getLogger(MessageValidator.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/value/matcher";
    public static final TypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/value/matcher");

    public static Map<String, ValueMatcher> lookup() {
        Map<String, ValueMatcher> validators = TYPE_RESOLVER.resolveAll();
        if (LOG.isDebugEnabled()) {
            validators.forEach((k, v) -> LOG.debug(String.format("Found value matcher '%s' as %s", k, v.getClass())));
        }
        return validators;
    }

    public static Optional<ValueMatcher> lookup(String validator) {
        try {
            ValueMatcher instance = (ValueMatcher)TYPE_RESOLVER.resolve(validator);
            return Optional.of(instance);
        }
        catch (CitrusRuntimeException e) {
            LOG.warn(String.format("Failed to resolve value matcher from resource '%s/%s'", RESOURCE_PATH, validator));
            return Optional.empty();
        }
    }

    public boolean supports(Class<?> var1);

    public boolean validate(Object var1, Object var2, TestContext var3);
}

