/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.matcher;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.NoSuchValidationMatcherLibraryException;
import com.consol.citrus.validation.matcher.ValidationMatcherLibrary;
import java.util.ArrayList;
import java.util.List;

public class ValidationMatcherRegistry {
    private List<ValidationMatcherLibrary> validationMatcherLibraries = new ArrayList<ValidationMatcherLibrary>();

    public ValidationMatcherLibrary getLibraryForPrefix(String validationMatcherPrefix) {
        if (this.validationMatcherLibraries != null) {
            for (ValidationMatcherLibrary validationMatcherLibrary : this.validationMatcherLibraries) {
                if (!validationMatcherLibrary.getPrefix().equals(validationMatcherPrefix)) continue;
                return validationMatcherLibrary;
            }
        }
        throw new NoSuchValidationMatcherLibraryException(String.format("Can not find validationMatcher library for prefix '%s'", validationMatcherPrefix));
    }

    public void addValidationMatcherLibrary(ValidationMatcherLibrary validationMatcherLibrary) {
        boolean prefixAlreadyUsed = this.validationMatcherLibraries.stream().anyMatch(lib -> lib.getPrefix().equals(validationMatcherLibrary.getPrefix()));
        if (prefixAlreadyUsed) {
            throw new CitrusRuntimeException(String.format("Validation matcher library prefix '%s' is already bound to another instance. Please choose another prefix.", validationMatcherLibrary.getPrefix()));
        }
        this.validationMatcherLibraries.add(validationMatcherLibrary);
    }

    public void setValidationMatcherLibraries(List<ValidationMatcherLibrary> validationMatcherLibraries) {
        this.validationMatcherLibraries = validationMatcherLibraries;
    }

    public List<ValidationMatcherLibrary> getValidationMatcherLibraries() {
        return this.validationMatcherLibraries;
    }
}

