/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.matcher;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.functions.FunctionUtils;
import com.consol.citrus.validation.matcher.ControlExpressionParser;
import com.consol.citrus.validation.matcher.DefaultControlExpressionParser;
import com.consol.citrus.validation.matcher.ValidationMatcher;
import com.consol.citrus.validation.matcher.ValidationMatcherLibrary;
import com.consol.citrus.variable.VariableUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.StringUtils;

public final class ValidationMatcherUtils {
    private ValidationMatcherUtils() {
    }

    public static void resolveValidationMatcher(String fieldName, String fieldValue, String validationMatcherExpression, TestContext context) {
        int bodyStart;
        String expression = VariableUtils.cutOffVariablesPrefix(ValidationMatcherUtils.cutOffValidationMatchersPrefix(validationMatcherExpression));
        if (expression.equals("ignore")) {
            expression = expression + "()";
        }
        if ((bodyStart = expression.indexOf(40)) < 0) {
            throw new CitrusRuntimeException("Illegal syntax for validation matcher expression - missing validation value in '()' function body");
        }
        String prefix = "";
        if (expression.indexOf(58) > 0 && expression.indexOf(58) < bodyStart) {
            prefix = expression.substring(0, expression.indexOf(58) + 1);
        }
        String matcherValue = expression.substring(bodyStart + 1, expression.length() - 1);
        String matcherName = expression.substring(prefix.length(), bodyStart);
        ValidationMatcherLibrary library = context.getValidationMatcherRegistry().getLibraryForPrefix(prefix);
        ValidationMatcher validationMatcher = library.getValidationMatcher(matcherName);
        ControlExpressionParser controlExpressionParser = ValidationMatcherUtils.lookupControlExpressionParser(validationMatcher);
        List<String> params = controlExpressionParser.extractControlValues(matcherValue, null);
        List<String> replacedParams = ValidationMatcherUtils.replaceVariablesAndFunctionsInParameters(params, context);
        validationMatcher.validate(fieldName, fieldValue, replacedParams, context);
    }

    private static List<String> replaceVariablesAndFunctionsInParameters(List<String> params, TestContext context) {
        ArrayList<String> replacedParams = new ArrayList<String>(params.size());
        for (String param : params) {
            String parsedVariablesParam = VariableUtils.replaceVariablesInString(param, context, false);
            String parsedFunctionsParam = FunctionUtils.replaceFunctionsInString(parsedVariablesParam, context);
            replacedParams.add(parsedFunctionsParam);
        }
        return replacedParams;
    }

    public static boolean isValidationMatcherExpression(String expression) {
        return expression.startsWith("@") && expression.endsWith("@");
    }

    private static String cutOffValidationMatchersPrefix(String expression) {
        if (expression.startsWith("@") && expression.endsWith("@")) {
            return expression.substring("@".length(), expression.length() - "@".length());
        }
        return expression;
    }

    private static ControlExpressionParser lookupControlExpressionParser(ValidationMatcher validationMatcher) {
        if (validationMatcher instanceof ControlExpressionParser) {
            return (ControlExpressionParser)((Object)validationMatcher);
        }
        return new DefaultControlExpressionParser();
    }

    public static String getParameterListAsString(List<String> parameters) {
        return StringUtils.collectionToDelimitedString(parameters, (String)",", (String)"'", (String)"'");
    }
}

