/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.xml.namespace;

import com.consol.citrus.message.Message;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.xml.namespace.SimpleNamespaceContext;

public class NamespaceContextBuilder {
    public static final String DEFAULT_BEAN_ID = "namespaceContextBuilder";
    private Map<String, String> namespaceMappings = new HashMap<String, String>();

    public NamespaceContext buildContext(Message receivedMessage, Map<String, String> namespaces) {
        SimpleNamespaceContext simpleNamespaceContext = new SimpleNamespaceContext();
        if (this.namespaceMappings.size() > 0) {
            simpleNamespaceContext.setBindings(this.namespaceMappings);
        }
        Map<String, String> dynamicBindings = NamespaceContextBuilder.lookupNamespaces(receivedMessage.getPayload(String.class));
        if (!CollectionUtils.isEmpty(namespaces)) {
            for (Map.Entry<String, String> binding : dynamicBindings.entrySet()) {
                if (namespaces.containsValue(binding.getValue())) continue;
                simpleNamespaceContext.bindNamespaceUri(binding.getKey(), binding.getValue());
            }
            simpleNamespaceContext.setBindings(namespaces);
        } else {
            simpleNamespaceContext.setBindings(dynamicBindings);
        }
        return simpleNamespaceContext;
    }

    public void setNamespaceMappings(Map<String, String> defaultMappings) {
        this.namespaceMappings = defaultMappings;
    }

    public Map<String, String> getNamespaceMappings() {
        return this.namespaceMappings;
    }

    public static Map<String, String> lookupNamespaces(String xml) {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        if (xml.indexOf("xmlns") != -1) {
            String[] tokens = StringUtils.split((String)xml, (String)"xmlns");
            do {
                String nsUri;
                String nsPrefix;
                String token;
                if ((token = tokens[1]).startsWith(":")) {
                    nsPrefix = token.substring(1, token.indexOf(61));
                } else if (token.startsWith("=")) {
                    nsPrefix = "";
                } else {
                    tokens = StringUtils.split((String)token, (String)"xmlns");
                    continue;
                }
                try {
                    nsUri = token.substring(token.indexOf(34) + 1, token.indexOf(34, token.indexOf(34) + 1));
                }
                catch (StringIndexOutOfBoundsException e) {
                    nsUri = token.substring(token.indexOf(39) + 1, token.indexOf(39, token.indexOf(39) + 1));
                }
                namespaces.put(nsPrefix, nsUri);
                tokens = StringUtils.split((String)token, (String)"xmlns");
            } while (tokens != null);
        }
        return namespaces;
    }
}

