/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.endpoint;

import com.consol.citrus.annotations.CitrusEndpoint;
import com.consol.citrus.annotations.CitrusEndpointConfig;
import com.consol.citrus.config.annotation.AnnotationConfigParser;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.endpoint.EndpointBuilder;
import com.consol.citrus.endpoint.EndpointComponent;
import com.consol.citrus.endpoint.EndpointFactory;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.spi.ReferenceResolver;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEndpointFactory
implements EndpointFactory {
    private static Logger log = LoggerFactory.getLogger(DefaultEndpointFactory.class);
    private final Map<String, Endpoint> endpointCache = new ConcurrentHashMap<String, Endpoint>();

    @Override
    public Endpoint create(String endpointName, Annotation endpointConfig, TestContext context) {
        String qualifier = endpointConfig.annotationType().getAnnotation(CitrusEndpointConfig.class).qualifier();
        Optional<AnnotationConfigParser> parser = Optional.ofNullable(context.getReferenceResolver().resolveAll(AnnotationConfigParser.class).get(qualifier));
        if (!parser.isPresent()) {
            parser = AnnotationConfigParser.lookup(qualifier);
        }
        if (parser.isPresent()) {
            Object endpoint = parser.get().parse(endpointConfig, context.getReferenceResolver());
            endpoint.setName(endpointName);
            return endpoint;
        }
        throw new CitrusRuntimeException(String.format("Unable to create endpoint annotation parser with name '%s'", qualifier));
    }

    @Override
    public Endpoint create(String endpointName, CitrusEndpoint endpointConfig, Class<?> endpointType, TestContext context) {
        Optional<EndpointBuilder> builder = context.getReferenceResolver().resolveAll(EndpointBuilder.class).values().stream().filter(endpointBuilder -> endpointBuilder.supports(endpointType)).findFirst();
        if (!builder.isPresent()) {
            builder = EndpointBuilder.lookup().values().stream().filter(endpointBuilder -> endpointBuilder.supports(endpointType)).findFirst();
        }
        if (builder.isPresent()) {
            Object endpoint = builder.get().build(endpointConfig, context.getReferenceResolver());
            endpoint.setName(endpointName);
            return endpoint;
        }
        throw new CitrusRuntimeException(String.format("Unable to create endpoint builder for type '%s'", endpointType.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Endpoint create(String uri, TestContext context) {
        String endpointUri = context.replaceDynamicContentInString(uri);
        if (!endpointUri.contains(":")) {
            return context.getReferenceResolver().resolve(endpointUri, Endpoint.class);
        }
        StringTokenizer tok = new StringTokenizer(endpointUri, ":");
        if (tok.countTokens() < 2) {
            throw new CitrusRuntimeException(String.format("Invalid endpoint uri '%s'", endpointUri));
        }
        String componentName = tok.nextToken();
        Optional<EndpointComponent> component = Optional.ofNullable(this.getEndpointComponents(context.getReferenceResolver()).get(componentName));
        if (!component.isPresent()) {
            component = EndpointComponent.lookup(componentName);
        }
        if (!component.isPresent()) {
            throw new CitrusRuntimeException(String.format("Unable to create endpoint component with name '%s'", componentName));
        }
        Map<String, String> parameters = component.get().getParameters(endpointUri);
        String cachedEndpointName = parameters.containsKey("endpointName") ? parameters.remove("endpointName") : endpointUri;
        Map<String, Endpoint> map = this.endpointCache;
        synchronized (map) {
            if (this.endpointCache.containsKey(cachedEndpointName)) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Found cached endpoint for uri '%s'", cachedEndpointName));
                }
                return this.endpointCache.get(cachedEndpointName);
            }
            Endpoint endpoint = component.get().createEndpoint(endpointUri, context);
            this.endpointCache.put(cachedEndpointName, endpoint);
            return endpoint;
        }
    }

    private Map<String, EndpointComponent> getEndpointComponents(ReferenceResolver referenceResolver) {
        return referenceResolver.resolveAll(EndpointComponent.class);
    }
}

