/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.message;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageDirection;
import com.consol.citrus.message.MessageDirectionAware;
import com.consol.citrus.message.MessageProcessor;
import com.consol.citrus.message.MessageTypeSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageProcessor
implements MessageProcessor,
MessageDirectionAware,
MessageTypeSelector {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private MessageDirection direction = MessageDirection.UNBOUND;

    @Override
    public void process(Message message, TestContext context) {
        if (this.supportsMessageType(message.getType())) {
            this.processMessage(message, context);
        } else {
            this.log.debug(String.format("Message processor '%s' skipped for message type: %s", this.getName(), message.getType()));
        }
    }

    protected void processMessage(Message message, TestContext context) {
    }

    @Override
    public boolean supportsMessageType(String messageType) {
        return true;
    }

    protected String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public MessageDirection getDirection() {
        return this.direction;
    }

    public void setDirection(MessageDirection direction) {
        this.direction = direction;
    }
}

