/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.message;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.message.Message;
import com.consol.citrus.spi.ResourcePathTypeResolver;
import com.consol.citrus.spi.TypeResolver;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface MessageSelector {
    public static final Logger LOG = LoggerFactory.getLogger(MessageSelector.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/message/selector";
    public static final TypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/message/selector");
    public static final Map<String, MessageSelectorFactory> factories = new HashMap<String, MessageSelectorFactory>();

    public static Map<String, MessageSelectorFactory> lookup() {
        if (factories.isEmpty()) {
            factories.putAll(TYPE_RESOLVER.resolveAll());
            if (LOG.isDebugEnabled()) {
                factories.forEach((k, v) -> LOG.debug(String.format("Found value matcher '%s' as %s", k, v.getClass())));
            }
        }
        return factories;
    }

    public boolean accept(Message var1);

    public static interface MessageSelectorFactory {
        public boolean supports(String var1);

        public MessageSelector create(String var1, String var2, TestContext var3);
    }

    public static final class AllAcceptingMessageSelector
    implements MessageSelector {
        @Override
        public boolean accept(Message message) {
            return true;
        }
    }
}

