/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.report;

import com.consol.citrus.report.TestSuiteListener;
import com.consol.citrus.report.TestSuiteListenerAware;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TestSuiteListeners
implements TestSuiteListenerAware {
    private final List<TestSuiteListener> testSuiteListeners = new ArrayList<TestSuiteListener>();

    @Override
    public void addTestSuiteListener(TestSuiteListener testSuiteListener) {
        if (!this.testSuiteListeners.contains(testSuiteListener)) {
            this.testSuiteListeners.add(testSuiteListener);
        }
    }

    public void onFinish() {
        for (TestSuiteListener listener : this.testSuiteListeners) {
            listener.onFinish();
        }
    }

    public void onFinishFailure(Throwable cause) {
        for (TestSuiteListener listener : this.testSuiteListeners) {
            listener.onFinishFailure(cause);
        }
    }

    public void onFinishSuccess() {
        for (TestSuiteListener listener : this.testSuiteListeners) {
            listener.onFinishSuccess();
        }
    }

    public void onStart() {
        for (TestSuiteListener listener : this.testSuiteListeners) {
            listener.onStart();
        }
    }

    public void onStartFailure(Throwable cause) {
        for (TestSuiteListener listener : this.testSuiteListeners) {
            listener.onStartFailure(cause);
        }
    }

    public void onStartSuccess() {
        for (TestSuiteListener listener : this.testSuiteListeners) {
            listener.onStartSuccess();
        }
    }

    public List<TestSuiteListener> getTestSuiteListeners() {
        return Collections.unmodifiableList(this.testSuiteListeners);
    }
}

