/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.util;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.TypeConverter;

public abstract class TypeConversionUtils {
    private static TypeConverter typeConverter = TypeConverter.lookupDefault();

    private TypeConversionUtils() {
    }

    public static void loadDefaultConverter() {
        typeConverter = TypeConverter.lookupDefault();
    }

    public static <T> T convertIfNecessary(Object target, Class<T> type) {
        return typeConverter.convertIfNecessary(target, type);
    }

    public static <T> T convertStringToType(String value, Class<T> type) {
        if (type.isAssignableFrom(String.class)) {
            return (T)value;
        }
        if (type.isAssignableFrom(Integer.TYPE) || type.isAssignableFrom(Integer.class)) {
            return (T)Integer.valueOf(value);
        }
        if (type.isAssignableFrom(Short.TYPE) || type.isAssignableFrom(Short.class)) {
            return (T)Short.valueOf(value);
        }
        if (type.isAssignableFrom(Byte.TYPE) || type.isAssignableFrom(Byte.class)) {
            return (T)Byte.valueOf(value);
        }
        if (type.isAssignableFrom(Long.TYPE) || type.isAssignableFrom(Long.class)) {
            return (T)Long.valueOf(value);
        }
        if (type.isAssignableFrom(Boolean.TYPE) || type.isAssignableFrom(Boolean.class)) {
            return (T)Boolean.valueOf(value);
        }
        if (type.isAssignableFrom(Float.TYPE) || type.isAssignableFrom(Float.class)) {
            return (T)Float.valueOf(value);
        }
        if (type.isAssignableFrom(Double.TYPE) || type.isAssignableFrom(Double.class)) {
            return (T)Double.valueOf(value);
        }
        throw new CitrusRuntimeException(String.format("Unable to convert '%s' to required type '%s'", value, type.getName()));
    }

    public static <T> T convertStringToType(String value, Class<T> type, TestContext context) {
        try {
            return TypeConversionUtils.convertStringToType(value, type);
        }
        catch (CitrusRuntimeException e) {
            T bean;
            if (context.getReferenceResolver() != null && context.getReferenceResolver().isResolvable(value) && type.isAssignableFrom((bean = context.getReferenceResolver().resolve(value, type)).getClass())) {
                return bean;
            }
            throw new CitrusRuntimeException(String.format("Unable to convert '%s' to required type '%s' - also no bean of required type available in application context", value, type.getName()), e.getCause());
        }
    }
}

