/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.util;

import com.consol.citrus.CitrusSettings;
import com.consol.citrus.spi.ResourcePathTypeResolver;
import com.consol.citrus.util.DefaultTypeConverter;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface TypeConverter {
    public static final Logger LOG = LoggerFactory.getLogger(TypeConverter.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/type/converter";
    public static final Map<String, TypeConverter> converters = new HashMap<String, TypeConverter>();

    public static Map<String, TypeConverter> lookup() {
        if (converters.isEmpty()) {
            converters.putAll(new ResourcePathTypeResolver().resolveAll(RESOURCE_PATH));
            if (converters.size() == 0) {
                converters.put("default", new DefaultTypeConverter());
            }
            if (LOG.isDebugEnabled()) {
                converters.forEach((k, v) -> LOG.debug(String.format("Found type converter '%s' as %s", k, v.getClass())));
            }
        }
        return converters;
    }

    public static TypeConverter lookupDefault() {
        String name = CitrusSettings.getTypeConverter();
        if (TypeConverter.lookup().size() == 1) {
            Map.Entry<String, TypeConverter> converterEntry = TypeConverter.lookup().entrySet().iterator().next();
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Using type converter '%s'", converterEntry.getKey()));
            }
            return converterEntry.getValue();
        }
        if (TypeConverter.lookup().containsKey(name)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Using type converter '%s'", name));
            }
            return TypeConverter.lookup().get(name);
        }
        LOG.warn(String.format("Missing type converter for name '%s' - using default type converter", name));
        return new DefaultTypeConverter();
    }

    public <T> T convertIfNecessary(Object var1, Class<T> var2);
}

