/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.message.Message;
import com.consol.citrus.validation.DefaultMessageValidator;
import com.consol.citrus.validation.context.ValidationContext;
import org.springframework.util.StringUtils;

public class DefaultEmptyMessageValidator
extends DefaultMessageValidator {
    @Override
    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, ValidationContext validationContext) {
        if (controlMessage == null || controlMessage.getPayload() == null) {
            this.log.debug("Skip message payload validation as no control message was defined");
            return;
        }
        if (StringUtils.hasText((String)controlMessage.getPayload(String.class))) {
            throw new ValidationException("Empty message validation failed - control message is not empty!");
        }
        this.log.debug("Start to verify empty message payload ...");
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received message:\n" + receivedMessage);
            this.log.debug("Control message:\n" + controlMessage);
        }
        if (StringUtils.hasText((String)receivedMessage.getPayload(String.class))) {
            throw new ValidationException("Validation failed - received message content is not empty!");
        }
        this.log.info("Message payload is empty as expected: All values OK");
    }
}

