/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.message.Message;
import com.consol.citrus.spi.ResourcePathTypeResolver;
import com.consol.citrus.spi.TypeResolver;
import com.consol.citrus.validation.context.ValidationContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface MessageValidator<T extends ValidationContext> {
    public static final Logger LOG = LoggerFactory.getLogger(MessageValidator.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/message/validator";
    public static final TypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/message/validator");
    public static final Map<String, MessageValidator<? extends ValidationContext>> validators = new HashMap<String, MessageValidator<? extends ValidationContext>>();

    public static Map<String, MessageValidator<? extends ValidationContext>> lookup() {
        if (validators.isEmpty()) {
            validators.putAll(TYPE_RESOLVER.resolveAll("", "type", "name"));
            if (LOG.isDebugEnabled()) {
                validators.forEach((k, v) -> LOG.debug(String.format("Found message validator '%s' as %s", k, v.getClass())));
            }
        }
        return validators;
    }

    public static Optional<MessageValidator<? extends ValidationContext>> lookup(String validator) {
        try {
            MessageValidator instance = (MessageValidator)TYPE_RESOLVER.resolve(validator, new Object[0]);
            return Optional.of(instance);
        }
        catch (CitrusRuntimeException e) {
            LOG.warn(String.format("Failed to resolve validator from resource '%s/%s'", RESOURCE_PATH, validator));
            return Optional.empty();
        }
    }

    public void validateMessage(Message var1, Message var2, TestContext var3, List<ValidationContext> var4) throws ValidationException;

    public boolean supportsMessageType(String var1, Message var2);
}

