/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.endpoint;

import com.consol.citrus.annotations.CitrusEndpoint;
import com.consol.citrus.annotations.CitrusEndpointProperty;
import com.consol.citrus.config.annotation.AnnotationConfigParser;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ResourcePathTypeResolver;
import com.consol.citrus.util.TypeConversionUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public interface EndpointBuilder<T extends Endpoint> {
    public static final Logger LOG = LoggerFactory.getLogger(AnnotationConfigParser.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/endpoint/builder";
    public static final ResourcePathTypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/endpoint/builder");

    public boolean supports(Class<?> var1);

    public T build();

    default public T build(CitrusEndpoint endpointAnnotation, ReferenceResolver referenceResolver) {
        Method nameSetter = ReflectionUtils.findMethod(this.getClass(), (String)"name", (Class[])new Class[]{String.class});
        if (nameSetter != null) {
            ReflectionUtils.invokeMethod((Method)nameSetter, (Object)this, (Object[])new Object[]{endpointAnnotation.name()});
        }
        for (CitrusEndpointProperty endpointProperty : endpointAnnotation.properties()) {
            Method propertyMethod = ReflectionUtils.findMethod(this.getClass(), (String)endpointProperty.name(), (Class[])new Class[]{endpointProperty.type()});
            if (propertyMethod == null) continue;
            if (!endpointProperty.type().equals(String.class) && referenceResolver.isResolvable(endpointProperty.value())) {
                ReflectionUtils.invokeMethod((Method)propertyMethod, (Object)this, (Object[])new Object[]{referenceResolver.resolve(endpointProperty.value(), endpointProperty.type())});
                continue;
            }
            ReflectionUtils.invokeMethod((Method)propertyMethod, (Object)this, (Object[])new Object[]{TypeConversionUtils.convertStringToType(endpointProperty.value(), endpointProperty.type())});
        }
        return this.build();
    }

    default public T build(Properties endpointProperties, ReferenceResolver referenceResolver) {
        for (Map.Entry<Object, Object> endpointProperty : endpointProperties.entrySet()) {
            Method propertyMethod = ReflectionUtils.findMethod(this.getClass(), (String)endpointProperty.getKey().toString(), (Class[])new Class[]{endpointProperty.getValue().getClass()});
            if (propertyMethod == null) continue;
            ReflectionUtils.invokeMethod((Method)propertyMethod, (Object)this, (Object[])new Object[]{endpointProperty.getValue()});
        }
        return this.build();
    }

    public static Map<String, EndpointBuilder> lookup() {
        HashMap<String, EndpointBuilder> builders = new HashMap<String, EndpointBuilder>(TYPE_RESOLVER.resolveAll("", "*"));
        if (LOG.isDebugEnabled()) {
            builders.forEach((k, v) -> LOG.debug(String.format("Found endpoint builder '%s' as %s", k, v.getClass())));
        }
        return builders;
    }

    public static Optional<EndpointBuilder> lookup(String builder) {
        try {
            EndpointBuilder instance;
            if (builder.contains(".")) {
                int separatorIndex = builder.lastIndexOf(46);
                instance = (EndpointBuilder)TYPE_RESOLVER.resolve(builder.substring(0, separatorIndex), builder.substring(separatorIndex + 1), new Object[0]);
            } else {
                instance = (EndpointBuilder)TYPE_RESOLVER.resolve(builder, new Object[0]);
            }
            return Optional.of(instance);
        }
        catch (CitrusRuntimeException e) {
            LOG.warn(String.format("Failed to resolve endpoint builder from resource '%s/%s'", RESOURCE_PATH, builder));
            return Optional.empty();
        }
    }
}

