/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.message;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import org.springframework.util.StringUtils;

public enum MessageHeaderType {
    INTEGER("integer", Integer.class),
    LONG("long", Long.class),
    FLOAT("float", Float.class),
    DOUBLE("double", Double.class),
    BYTE("byte", Byte.class),
    SHORT("short", Short.class),
    BOOLEAN("boolean", Boolean.class),
    STRING("string", String.class);

    public static final String TYPE_PREFIX = "{";
    public static final String TYPE_SUFFIX = "}:";
    private String name;
    private Class<?> clazz;

    private MessageHeaderType(String name, Class<?> clazz) {
        this.name = name;
        this.clazz = clazz;
    }

    public static boolean isTyped(String headerValue) {
        if (!StringUtils.hasText((String)headerValue)) {
            return false;
        }
        for (MessageHeaderType messageType : MessageHeaderType.values()) {
            if (!headerValue.startsWith(TYPE_PREFIX + messageType.getName() + TYPE_SUFFIX)) continue;
            return true;
        }
        return false;
    }

    public static String createTypedValue(String type, String value) {
        return TYPE_PREFIX + type + TYPE_SUFFIX + value;
    }

    public static MessageHeaderType fromTypedValue(String headerValue) {
        String typeName = headerValue.substring(1, headerValue.indexOf(TYPE_SUFFIX));
        for (MessageHeaderType messageType : MessageHeaderType.values()) {
            if (!messageType.getName().equals(typeName)) continue;
            return messageType;
        }
        throw new CitrusRuntimeException("Unknown message header type in header value " + headerValue);
    }

    public static String removeTypeDefinition(String headerValue) {
        if (MessageHeaderType.isTyped(headerValue)) {
            return headerValue.substring(headerValue.indexOf(TYPE_SUFFIX) + TYPE_SUFFIX.length());
        }
        return headerValue;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getHeaderClass() {
        return this.clazz;
    }
}

