/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.endpoint;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.spi.ResourcePathTypeResolver;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface EndpointComponent {
    public static final Logger LOG = LoggerFactory.getLogger(EndpointComponent.class);
    public static final String ENDPOINT_NAME = "endpointName";
    public static final String RESOURCE_PATH = "META-INF/citrus/endpoint/component";
    public static final ResourcePathTypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/endpoint/component");

    public Endpoint createEndpoint(String var1, TestContext var2);

    public String getName();

    public Map<String, String> getParameters(String var1);

    public static Map<String, EndpointComponent> lookup() {
        Map<String, EndpointComponent> components = TYPE_RESOLVER.resolveAll();
        if (LOG.isDebugEnabled()) {
            components.forEach((k, v) -> LOG.debug(String.format("Found endpoint component '%s' as %s", k, v.getClass())));
        }
        return components;
    }

    public static Optional<EndpointComponent> lookup(String component) {
        try {
            EndpointComponent instance = (EndpointComponent)TYPE_RESOLVER.resolve(component, new Object[0]);
            return Optional.of(instance);
        }
        catch (CitrusRuntimeException e) {
            LOG.warn(String.format("Failed to resolve endpoint component from resource '%s/%s'", RESOURCE_PATH, component));
            return Optional.empty();
        }
    }
}

