/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.report;

import com.consol.citrus.TestCase;
import com.consol.citrus.TestResult;
import com.consol.citrus.report.TestListener;
import com.consol.citrus.report.TestReporter;
import com.consol.citrus.report.TestReporterAware;
import com.consol.citrus.report.TestReporterSettings;
import com.consol.citrus.report.TestResults;
import com.consol.citrus.report.TestSuiteListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TestReporters
implements TestListener,
TestSuiteListener,
TestReporterAware {
    private boolean autoClear = TestReporterSettings.isAutoClear();
    private final List<TestReporter> testReporters = new ArrayList<TestReporter>();
    private TestResults testResults = new TestResults();

    private void generateReports() {
        for (TestReporter reporter : this.testReporters) {
            reporter.generateReport(this.testResults);
        }
    }

    @Override
    public void onStart() {
        if (this.autoClear) {
            this.testResults = new TestResults();
        }
    }

    @Override
    public void onFinishFailure(Throwable cause) {
        this.generateReports();
    }

    @Override
    public void onFinishSuccess() {
        this.generateReports();
    }

    public TestResults getTestResults() {
        return this.testResults;
    }

    @Override
    public void onFinish() {
    }

    @Override
    public void onStartFailure(Throwable cause) {
    }

    @Override
    public void onStartSuccess() {
    }

    @Override
    public void onTestStart(TestCase test) {
    }

    @Override
    public void onTestFinish(TestCase test) {
    }

    @Override
    public void onTestSuccess(TestCase test) {
        this.testResults.addResult(TestResult.success(test.getName(), test.getTestClass().getName()));
    }

    @Override
    public void onTestFailure(TestCase test, Throwable cause) {
        this.testResults.addResult(TestResult.failed(test.getName(), test.getTestClass().getName(), cause));
    }

    @Override
    public void onTestSkipped(TestCase test) {
        this.testResults.addResult(TestResult.skipped(test.getName(), test.getTestClass().getName()));
    }

    @Override
    public void addTestReporter(TestReporter testReporter) {
        this.testReporters.add(testReporter);
    }

    public List<TestReporter> getTestReporters() {
        return Collections.unmodifiableList(this.testReporters);
    }

    public boolean isAutoClear() {
        return this.autoClear;
    }

    public void setAutoClear(boolean autoClear) {
        this.autoClear = autoClear;
    }
}

