/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.message;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageTransformer;
import com.consol.citrus.spi.ResourcePathTypeResolver;
import com.consol.citrus.spi.TypeResolver;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface MessageProcessor
extends MessageTransformer {
    public static final Logger LOG = LoggerFactory.getLogger(MessageProcessor.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/message/processor";
    public static final TypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/message/processor");

    public static <T extends MessageProcessor, B extends Builder<T, B>> Optional<Builder<T, B>> lookup(String processor) {
        try {
            Builder instance = (Builder)TYPE_RESOLVER.resolve(processor, new Object[0]);
            return Optional.of(instance);
        }
        catch (CitrusRuntimeException e) {
            LOG.warn(String.format("Failed to resolve message processor from resource '%s/%s'", RESOURCE_PATH, processor));
            return Optional.empty();
        }
    }

    public void process(Message var1, TestContext var2);

    @Override
    default public Message transform(Message message, TestContext context) {
        this.process(message, context);
        return message;
    }

    public static interface Builder<T extends MessageProcessor, B extends Builder<T, B>> {
        public T build();
    }
}

