/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.variable;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.spi.ResourcePathTypeResolver;
import com.consol.citrus.spi.TypeResolver;
import com.consol.citrus.variable.SegmentVariableExtractor;
import com.consol.citrus.variable.VariableExpressionSegmentMatcher;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class SegmentVariableExtractorRegistry {
    private static final Logger log = LoggerFactory.getLogger(SegmentVariableExtractor.class);
    private static final String RESOURCE_PATH = "META-INF/citrus/variable/extractor/segment";
    private static final TypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/variable/extractor/segment");
    private final List<SegmentVariableExtractor> segmentValueExtractors = new ArrayList<ObjectFieldValueExtractor>(List.of(MapVariableExtractor.INSTANCE, ObjectFieldValueExtractor.INSTANCE));

    static Collection<SegmentVariableExtractor> lookup() {
        try {
            Map extractors = TYPE_RESOLVER.resolveAll();
            return extractors.values();
        }
        catch (CitrusRuntimeException e) {
            log.warn(String.format("Failed to resolve segment variable extractor from resource '%s'", RESOURCE_PATH));
            return Collections.emptyList();
        }
    }

    public SegmentVariableExtractorRegistry() {
        this.segmentValueExtractors.addAll(SegmentVariableExtractorRegistry.lookup());
    }

    public List<SegmentVariableExtractor> getSegmentValueExtractors() {
        return this.segmentValueExtractors;
    }

    public static class MapVariableExtractor
    extends IndexedSegmentVariableExtractor {
        public static MapVariableExtractor INSTANCE = new MapVariableExtractor();

        private MapVariableExtractor() {
        }

        @Override
        protected Object doExtractIndexedValue(TestContext testContext, Object parentObject, VariableExpressionSegmentMatcher matcher) {
            Object matchedValue = null;
            if (parentObject instanceof Map) {
                matchedValue = ((Map)parentObject).get(matcher.getSegmentExpression());
            }
            return matchedValue;
        }

        @Override
        public boolean canExtract(TestContext testContext, Object object, VariableExpressionSegmentMatcher matcher) {
            return object instanceof Map;
        }
    }

    public static class ObjectFieldValueExtractor
    extends IndexedSegmentVariableExtractor {
        public static ObjectFieldValueExtractor INSTANCE = new ObjectFieldValueExtractor();

        private ObjectFieldValueExtractor() {
        }

        @Override
        protected Object doExtractIndexedValue(TestContext testContext, Object parentObject, VariableExpressionSegmentMatcher matcher) {
            Field field = ReflectionUtils.findField(parentObject.getClass(), (String)matcher.getSegmentExpression());
            if (field == null) {
                throw new CitrusRuntimeException(String.format("Failed to get variable - unknown field '%s' on type %s", matcher.getSegmentExpression(), parentObject.getClass().getName()));
            }
            ReflectionUtils.makeAccessible((Field)field);
            return ReflectionUtils.getField((Field)field, (Object)parentObject);
        }

        @Override
        public boolean canExtract(TestContext testContext, Object object, VariableExpressionSegmentMatcher matcher) {
            return object != null && !(object instanceof String);
        }
    }

    public static abstract class IndexedSegmentVariableExtractor
    extends AbstractSegmentVariableExtractor {
        @Override
        public final Object doExtractValue(TestContext testContext, Object object, VariableExpressionSegmentMatcher matcher) {
            Object extractedValue = this.doExtractIndexedValue(testContext, object, matcher);
            if (matcher.getSegmentIndex() != -1) {
                extractedValue = this.getIndexedElement(matcher, extractedValue);
            }
            return extractedValue;
        }

        private Object getIndexedElement(VariableExpressionSegmentMatcher matcher, Object indexedValue) {
            if (indexedValue.getClass().isArray()) {
                return Array.get(indexedValue, matcher.getSegmentIndex());
            }
            throw new CitrusRuntimeException(String.format("Expected an instance of Array type. Cannot retrieve indexed property %s from %s ", matcher.getSegmentExpression(), indexedValue.getClass().getName()));
        }

        protected abstract Object doExtractIndexedValue(TestContext var1, Object var2, VariableExpressionSegmentMatcher var3);
    }

    public static abstract class AbstractSegmentVariableExtractor
    implements SegmentVariableExtractor {
        @Override
        public final Object extractValue(TestContext testContext, Object object, VariableExpressionSegmentMatcher matcher) {
            Object matchedValue = this.doExtractValue(testContext, object, matcher);
            if (matchedValue == null) {
                this.handleMatchFailure(matcher);
            }
            return matchedValue;
        }

        private void handleMatchFailure(VariableExpressionSegmentMatcher matcher) {
            String exceptionMessage = matcher.getTotalSegmentCount() == 1 ? String.format("Unknown variable '%s'", matcher.getVariableExpression()) : (matcher.getSegmentIndex() == 1 ? String.format("Unknown variable for first segment '%s' of variable expression '%s'", matcher.getSegmentExpression(), matcher.getVariableExpression()) : String.format("Unknown segment-value for segment '%s' of variable expression '%s'", matcher.getSegmentExpression(), matcher.getVariableExpression()));
            throw new CitrusRuntimeException(exceptionMessage);
        }

        protected abstract Object doExtractValue(TestContext var1, Object var2, VariableExpressionSegmentMatcher var3);
    }
}

