/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.matcher;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.validation.matcher.ControlExpressionParser;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.StringUtils;

public class DefaultControlExpressionParser
implements ControlExpressionParser {
    @Override
    public List<String> extractControlValues(String controlExpression, Character delimiter) {
        Character useDelimiter = delimiter != null ? delimiter : DEFAULT_DELIMITER;
        ArrayList<String> extractedParameters = new ArrayList<String>();
        if (StringUtils.hasText((String)controlExpression)) {
            this.extractParameters(controlExpression, useDelimiter, extractedParameters, 0);
            if (extractedParameters.size() == 0) {
                extractedParameters.add(controlExpression);
            }
        }
        return extractedParameters;
    }

    private void extractParameters(String controlExp, Character delim, List<String> extractedParameters, int searchFrom) {
        int startParameter = controlExp.indexOf(delim.charValue(), searchFrom);
        if (startParameter > -1) {
            int endParameter = controlExp.indexOf(delim.charValue(), startParameter + 1);
            boolean isEnd = false;
            while (!isEnd && endParameter > 0 && endParameter < controlExp.length() - 2) {
                if (controlExp.charAt(endParameter + 1) == ',' || controlExp.charAt(endParameter + 1) == ')') {
                    isEnd = true;
                    continue;
                }
                endParameter = controlExp.indexOf(delim.charValue(), endParameter + 1);
            }
            if (endParameter > -1) {
                String extractedParameter = controlExp.substring(startParameter + 1, endParameter);
                extractedParameters.add(extractedParameter);
                int commaSeparator = controlExp.indexOf(44, endParameter);
                if (commaSeparator > -1) {
                    this.extractParameters(controlExp, delim, extractedParameters, endParameter + 1);
                }
            } else {
                throw new CitrusRuntimeException(String.format("No matching delimiter (%s) found after position '%s' in control expression: %s", delim, endParameter, controlExp));
            }
        }
    }
}

