/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.message;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.log.LogMessageModifier;
import com.consol.citrus.message.MessagePayloadUtils;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public interface Message
extends Serializable {
    default public String print() {
        return this.print(this.getPayload(String.class).trim(), this.getHeaders(), this.getHeaderData());
    }

    default public String print(String body, Map<String, Object> headers, List<String> headerData) {
        if (CollectionUtils.isEmpty(headerData)) {
            return this.getClass().getSimpleName().toUpperCase() + " [id: " + this.getId() + ", payload: " + MessagePayloadUtils.prettyPrint(body) + "][headers: " + Collections.unmodifiableMap(headers) + "]";
        }
        return this.getClass().getSimpleName().toUpperCase() + " [id: " + this.getId() + ", payload: " + MessagePayloadUtils.prettyPrint(body) + "][headers: " + Collections.unmodifiableMap(headers) + "][header-data: " + Collections.unmodifiableList(headerData) + "]";
    }

    default public String print(TestContext context) {
        if (context == null) {
            return this.print();
        }
        if (context.getLogModifier() instanceof LogMessageModifier) {
            LogMessageModifier modifier = (LogMessageModifier)context.getLogModifier();
            return this.print(modifier.maskBody(this), modifier.maskHeaders(this), modifier.maskHeaderData(this));
        }
        return this.print(context.getLogModifier().mask(this.getPayload(String.class).trim()), this.getHeaders(), this.getHeaderData());
    }

    public String getId();

    public String getType();

    public Message setType(String var1);

    public String getName();

    public Message setName(String var1);

    public Object getHeader(String var1);

    public Message setHeader(String var1, Object var2);

    public void removeHeader(String var1);

    public Message addHeaderData(String var1);

    public List<String> getHeaderData();

    public Map<String, Object> getHeaders();

    public <T> T getPayload(Class<T> var1);

    public Object getPayload();

    public Message setPayload(Object var1);
}

