/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.message;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.MessagePayloadBuilder;
import com.consol.citrus.spi.ResourcePathTypeResolver;
import com.consol.citrus.spi.TypeResolver;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public interface ScriptPayloadBuilder
extends MessagePayloadBuilder {
    public static final Logger LOG = LoggerFactory.getLogger(ScriptPayloadBuilder.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/script/message/builder";
    public static final TypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/script/message/builder");

    public static <T extends ScriptPayloadBuilder> Optional<T> lookup(String type) {
        try {
            ScriptPayloadBuilder instance = (ScriptPayloadBuilder)TYPE_RESOLVER.resolve(type, new Object[0]);
            return Optional.of(instance);
        }
        catch (CitrusRuntimeException e) {
            LOG.warn(String.format("Failed to resolve script payload builder from resource '%s/%s'", RESOURCE_PATH, type));
            return Optional.empty();
        }
    }

    public void setScript(String var1);

    public void setFile(Resource var1);
}

