/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.spi.ResourcePathTypeResolver;
import com.consol.citrus.spi.TypeResolver;
import com.consol.citrus.validation.MessageValidator;
import com.consol.citrus.validation.context.SchemaValidationContext;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SchemaValidator<T extends SchemaValidationContext> {
    public static final Logger LOG = LoggerFactory.getLogger(MessageValidator.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/message/schemaValidator";
    public static final TypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/message/schemaValidator");

    public static Map<String, SchemaValidator<? extends SchemaValidationContext>> lookup() {
        Map<String, SchemaValidator<? extends SchemaValidationContext>> validators = TYPE_RESOLVER.resolveAll("", "type", "name");
        if (LOG.isDebugEnabled()) {
            validators.forEach((k, v) -> LOG.debug(String.format("Found message validator '%s' as %s", k, v.getClass())));
        }
        return validators;
    }

    public static Optional<SchemaValidator<? extends SchemaValidationContext>> lookup(String validator) {
        try {
            SchemaValidator instance = (SchemaValidator)TYPE_RESOLVER.resolve(validator, new Object[0]);
            return Optional.of(instance);
        }
        catch (CitrusRuntimeException e) {
            LOG.warn(String.format("Failed to resolve validator from resource '%s/%s'", RESOURCE_PATH, validator));
            return Optional.empty();
        }
    }

    public void validate(Message var1, TestContext var2, T var3);

    public boolean supportsMessageType(String var1, Message var2);
}

