/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.context;

import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.TestActor;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestCaseMetaInfo;
import com.consol.citrus.TestResult;
import com.consol.citrus.container.AfterTest;
import com.consol.citrus.container.BeforeTest;
import com.consol.citrus.container.StopTimer;
import com.consol.citrus.container.TestActionContainer;
import com.consol.citrus.endpoint.EndpointFactory;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.VariableNullValueException;
import com.consol.citrus.functions.FunctionRegistry;
import com.consol.citrus.functions.FunctionUtils;
import com.consol.citrus.log.LogModifier;
import com.consol.citrus.message.DefaultMessageStore;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageDirection;
import com.consol.citrus.message.MessageDirectionAware;
import com.consol.citrus.message.MessageProcessor;
import com.consol.citrus.message.MessageProcessors;
import com.consol.citrus.message.MessageStore;
import com.consol.citrus.report.MessageListeners;
import com.consol.citrus.report.TestActionListener;
import com.consol.citrus.report.TestActionListenerAware;
import com.consol.citrus.report.TestActionListeners;
import com.consol.citrus.report.TestListeners;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import com.consol.citrus.util.TypeConverter;
import com.consol.citrus.validation.MessageValidatorRegistry;
import com.consol.citrus.validation.matcher.ValidationMatcherRegistry;
import com.consol.citrus.variable.GlobalVariables;
import com.consol.citrus.variable.SegmentVariableExtractorRegistry;
import com.consol.citrus.variable.VariableExpressionIterator;
import com.consol.citrus.variable.VariableUtils;
import com.consol.citrus.xml.namespace.NamespaceContextBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class TestContext
implements ReferenceResolverAware,
TestActionListenerAware {
    private static final Logger LOG = LoggerFactory.getLogger(TestContext.class);
    protected Map<String, Object> variables;
    private GlobalVariables globalVariables;
    private MessageStore messageStore = new DefaultMessageStore();
    private FunctionRegistry functionRegistry = new FunctionRegistry();
    private EndpointFactory endpointFactory;
    private ReferenceResolver referenceResolver;
    private MessageValidatorRegistry messageValidatorRegistry = new MessageValidatorRegistry();
    private ValidationMatcherRegistry validationMatcherRegistry = new ValidationMatcherRegistry();
    private TestListeners testListeners = new TestListeners();
    private TestActionListeners testActionListeners = new TestActionListeners();
    private List<BeforeTest> beforeTest = new ArrayList<BeforeTest>();
    private List<AfterTest> afterTest = new ArrayList<AfterTest>();
    private MessageListeners messageListeners = new MessageListeners();
    private MessageProcessors messageProcessors = new MessageProcessors();
    private NamespaceContextBuilder namespaceContextBuilder = new NamespaceContextBuilder();
    protected Map<String, StopTimer> timers = new ConcurrentHashMap<String, StopTimer>();
    private final List<CitrusRuntimeException> exceptions = new ArrayList<CitrusRuntimeException>();
    private TypeConverter typeConverter = TypeConverter.lookupDefault();
    private LogModifier logModifier;
    private SegmentVariableExtractorRegistry segmentVariableExtractorRegistry = new SegmentVariableExtractorRegistry();

    public TestContext() {
        this.variables = new ConcurrentHashMap<String, Object>();
    }

    public String getVariable(String variableExpression) {
        return this.getVariable(variableExpression, String.class);
    }

    public <T> T getVariable(String variableExpression, Class<T> type) {
        return this.typeConverter.convertIfNecessary(this.getVariableObject(variableExpression), type);
    }

    public Object getVariableObject(String variableExpression) {
        String variableName = VariableUtils.cutOffVariablesPrefix(variableExpression);
        if (variableName.startsWith("//") && variableName.endsWith("//")) {
            return "${" + VariableUtils.cutOffVariablesEscaping(variableName) + "}";
        }
        if (this.variables.containsKey(variableName)) {
            return this.variables.get(variableName);
        }
        return VariableExpressionIterator.getLastExpressionValue(variableName, this, this.segmentVariableExtractorRegistry.getSegmentValueExtractors());
    }

    public void setVariable(String variableName, Object value) {
        if (!StringUtils.hasText((String)variableName) || VariableUtils.cutOffVariablesPrefix(variableName).length() == 0) {
            throw new CitrusRuntimeException("Can not create variable '" + variableName + "', please define proper variable name");
        }
        if (value == null) {
            throw new VariableNullValueException("Trying to set variable: " + VariableUtils.cutOffVariablesPrefix(variableName) + ", but variable value is null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Setting variable: %s with value: '%s'", VariableUtils.cutOffVariablesPrefix(variableName), value));
        }
        this.variables.put(VariableUtils.cutOffVariablesPrefix(variableName), value);
    }

    public void addVariables(String[] variableNames, Object[] variableValues) {
        if (variableNames.length != variableValues.length) {
            throw new CitrusRuntimeException(String.format("Invalid context variable usage - received '%s' variables with '%s' values", variableNames.length, variableValues.length));
        }
        for (int i = 0; i < variableNames.length; ++i) {
            if (variableValues[i] == null) continue;
            this.setVariable(variableNames[i], variableValues[i]);
        }
    }

    public void addVariables(Map<String, Object> variablesToSet) {
        for (Map.Entry<String, Object> entry : variablesToSet.entrySet()) {
            if (entry.getValue() != null) {
                this.setVariable(entry.getKey(), entry.getValue());
                continue;
            }
            this.setVariable(entry.getKey(), "");
        }
    }

    public <T> Map<String, T> resolveDynamicValuesInMap(Map<String, T> map) {
        LinkedHashMap<String, T> target = new LinkedHashMap<String, T>(map.size());
        for (Map.Entry<String, T> entry : map.entrySet()) {
            String adaptedKey = this.resolveDynamicContentIfRequired(entry.getKey());
            T adaptedValue = this.resolveDynamicContentIfRequired(entry.getValue());
            target.put(adaptedKey, adaptedValue);
        }
        return target;
    }

    public <T> List<T> resolveDynamicValuesInList(List<T> list) {
        ArrayList<String> variableFreeList = new ArrayList<String>(list.size());
        for (T value : list) {
            if (!(value instanceof String)) continue;
            variableFreeList.add(this.replaceDynamicContentInString((String)value));
        }
        return variableFreeList;
    }

    private <V> V resolveDynamicContentIfRequired(V value) {
        Object adaptedValue = value instanceof String ? this.replaceDynamicContentInString((String)value) : value;
        return adaptedValue;
    }

    public <T> T[] resolveDynamicValuesInArray(T[] array) {
        return this.resolveDynamicValuesInList(Arrays.asList(array)).toArray(Arrays.copyOf(array, array.length));
    }

    public void clear() {
        this.variables.clear();
        this.variables.putAll(this.globalVariables.getVariables());
    }

    public boolean hasVariables() {
        return !CollectionUtils.isEmpty(this.variables);
    }

    public String replaceDynamicContentInString(String str) {
        return this.replaceDynamicContentInString(str, false);
    }

    public String replaceDynamicContentInString(String str, boolean enableQuoting) {
        String result = null;
        if (str != null) {
            result = VariableUtils.replaceVariablesInString(str, this, enableQuoting);
            result = FunctionUtils.replaceFunctionsInString(result, this, enableQuoting);
        }
        return result;
    }

    public String resolveDynamicValue(String expression) {
        if (VariableUtils.isVariableName(expression)) {
            return this.getVariable(expression);
        }
        if (this.functionRegistry.isFunction(expression)) {
            return FunctionUtils.resolveFunction(expression, this);
        }
        return expression;
    }

    public CitrusRuntimeException handleError(String testName, String packageName, String message, Exception cause) {
        EmptyTestCase dummyTest = new EmptyTestCase(testName, packageName);
        CitrusRuntimeException exception = new CitrusRuntimeException(message, cause);
        try {
            this.testListeners.onTestStart(dummyTest);
            this.testListeners.onTestFailure(dummyTest, exception);
            this.testListeners.onTestFinish(dummyTest);
        }
        catch (Exception e) {
            LOG.warn("Executing error handler listener failed!", (Throwable)e);
        }
        return exception;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setGlobalVariables(GlobalVariables globalVariables) {
        GlobalVariables.Builder builder = new GlobalVariables.Builder();
        for (Map.Entry<String, Object> entry : globalVariables.getVariables().entrySet()) {
            String adaptedKey = this.resolveDynamicContentIfRequired(entry.getKey());
            Object adaptedValue = this.resolveDynamicContentIfRequired(entry.getValue());
            this.variables.put(adaptedKey, adaptedValue);
            builder.variable(adaptedKey, adaptedValue);
        }
        this.globalVariables = builder.build();
    }

    public Map<String, Object> getGlobalVariables() {
        return this.globalVariables.getVariables();
    }

    public void setMessageStore(MessageStore messageStore) {
        this.messageStore = messageStore;
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    public FunctionRegistry getFunctionRegistry() {
        return this.functionRegistry;
    }

    public void setFunctionRegistry(FunctionRegistry functionRegistry) {
        this.functionRegistry = functionRegistry;
    }

    public void setMessageValidatorRegistry(MessageValidatorRegistry messageValidatorRegistry) {
        this.messageValidatorRegistry = messageValidatorRegistry;
    }

    public MessageValidatorRegistry getMessageValidatorRegistry() {
        return this.messageValidatorRegistry;
    }

    public ValidationMatcherRegistry getValidationMatcherRegistry() {
        return this.validationMatcherRegistry;
    }

    public void setValidationMatcherRegistry(ValidationMatcherRegistry validationMatcherRegistry) {
        this.validationMatcherRegistry = validationMatcherRegistry;
    }

    public MessageListeners getMessageListeners() {
        return this.messageListeners;
    }

    public void setMessageListeners(MessageListeners messageListeners) {
        this.messageListeners = messageListeners;
    }

    public TestListeners getTestListeners() {
        return this.testListeners;
    }

    public void setTestListeners(TestListeners testListeners) {
        this.testListeners = testListeners;
    }

    public TestActionListeners getTestActionListeners() {
        return this.testActionListeners;
    }

    public void setTestActionListeners(TestActionListeners testActionListeners) {
        this.testActionListeners = testActionListeners;
    }

    @Override
    public void addTestActionListener(TestActionListener listener) {
        this.testActionListeners.addTestActionListener(listener);
    }

    public List<BeforeTest> getBeforeTest() {
        return this.beforeTest;
    }

    public void setBeforeTest(List<BeforeTest> beforeTest) {
        this.beforeTest = beforeTest;
    }

    public List<AfterTest> getAfterTest() {
        return this.afterTest;
    }

    public void setAfterTest(List<AfterTest> afterTest) {
        this.afterTest = afterTest;
    }

    public SegmentVariableExtractorRegistry getSegmentVariableExtractorRegistry() {
        return this.segmentVariableExtractorRegistry;
    }

    public void setSegmentVariableExtractorRegistry(SegmentVariableExtractorRegistry segmentVariableExtractorRegistry) {
        this.segmentVariableExtractorRegistry = segmentVariableExtractorRegistry;
    }

    public List<MessageProcessor> getMessageProcessors(MessageDirection direction) {
        return this.messageProcessors.getMessageProcessors().stream().filter(processor -> {
            MessageDirection processorDirection = MessageDirection.UNBOUND;
            if (processor instanceof MessageDirectionAware) {
                processorDirection = ((MessageDirectionAware)((Object)processor)).getDirection();
            }
            return processorDirection.equals((Object)direction) || processorDirection.equals((Object)MessageDirection.UNBOUND);
        }).collect(Collectors.toList());
    }

    public MessageProcessors getMessageProcessors() {
        return this.messageProcessors;
    }

    public void setMessageProcessors(MessageProcessors messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public EndpointFactory getEndpointFactory() {
        return this.endpointFactory;
    }

    public void setEndpointFactory(EndpointFactory endpointFactory) {
        this.endpointFactory = endpointFactory;
    }

    public ReferenceResolver getReferenceResolver() {
        return this.referenceResolver;
    }

    @Override
    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    public void setNamespaceContextBuilder(NamespaceContextBuilder namespaceContextBuilder) {
        this.namespaceContextBuilder = namespaceContextBuilder;
    }

    public NamespaceContextBuilder getNamespaceContextBuilder() {
        return this.namespaceContextBuilder;
    }

    public TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    public void setTypeConverter(TypeConverter typeConverter) {
        this.typeConverter = typeConverter;
    }

    public LogModifier getLogModifier() {
        return this.logModifier;
    }

    public void setLogModifier(LogModifier logModifier) {
        this.logModifier = logModifier;
    }

    public void onInboundMessage(Message receivedMessage) {
        this.logMessage("Receive", receivedMessage, MessageDirection.INBOUND);
    }

    public void onOutboundMessage(Message message) {
        this.logMessage("Send", message, MessageDirection.OUTBOUND);
    }

    private void logMessage(String operation, Message message, MessageDirection direction) {
        if (this.messageListeners != null && !this.messageListeners.isEmpty()) {
            if (MessageDirection.OUTBOUND.equals((Object)direction)) {
                this.messageListeners.onOutboundMessage(message, this);
            } else if (MessageDirection.INBOUND.equals((Object)direction)) {
                this.messageListeners.onInboundMessage(message, this);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("%s message:%n%s", operation, Optional.ofNullable(message).map(Object::toString).orElse("")));
        }
    }

    public void registerTimer(String timerId, StopTimer timer) {
        if (this.timers.containsKey(timerId)) {
            throw new CitrusRuntimeException("Timer already registered with this id");
        }
        this.timers.put(timerId, timer);
    }

    public boolean stopTimer(String timerId) {
        StopTimer timer = this.timers.get(timerId);
        if (timer != null) {
            timer.stopTimer();
            return true;
        }
        return false;
    }

    public void stopTimers() {
        for (String timerId : this.timers.keySet()) {
            this.stopTimer(timerId);
        }
    }

    public void addException(CitrusRuntimeException exception) {
        this.exceptions.add(exception);
    }

    public List<CitrusRuntimeException> getExceptions() {
        return this.exceptions;
    }

    public boolean hasExceptions() {
        return !CollectionUtils.isEmpty(this.getExceptions());
    }

    public boolean isSuccess(TestResult testResult) {
        return !this.hasExceptions() && Optional.ofNullable(testResult).map(TestResult::isSuccess).orElse(false) != false;
    }

    static class EmptyTestCase
    implements TestCase {
        private final String testName;
        private final String packageName;

        public EmptyTestCase(String testName, String packageName) {
            this.testName = testName;
            this.packageName = packageName;
        }

        @Override
        public String getName() {
            return this.testName;
        }

        @Override
        public String getPackageName() {
            return this.packageName;
        }

        @Override
        public Map<String, Object> getVariableDefinitions() {
            return Collections.emptyMap();
        }

        @Override
        public TestActionContainer setActions(List<TestAction> actions) {
            return this;
        }

        @Override
        public List<TestAction> getActions() {
            return Collections.emptyList();
        }

        @Override
        public List<TestActionBuilder<?>> getActionBuilders() {
            return Collections.emptyList();
        }

        @Override
        public long getActionCount() {
            return 0L;
        }

        @Override
        public TestActionContainer addTestActions(TestAction ... action) {
            return this;
        }

        @Override
        public TestActionContainer addTestAction(TestAction action) {
            return this;
        }

        @Override
        public int getActionIndex(TestAction action) {
            return 0;
        }

        @Override
        public TestAction getActiveAction() {
            return null;
        }

        @Override
        public List<TestAction> getExecutedActions() {
            return Collections.emptyList();
        }

        @Override
        public TestAction getTestAction(int index) {
            return null;
        }

        @Override
        public String getDescription() {
            return "Empty test";
        }

        @Override
        public TestAction setDescription(String description) {
            return this;
        }

        @Override
        public boolean isDisabled(TestContext context) {
            return false;
        }

        @Override
        public TestActor getActor() {
            return null;
        }

        @Override
        public void setName(String name) {
        }

        @Override
        public void execute(TestContext context) {
        }

        @Override
        public void start(TestContext context) {
        }

        @Override
        public void executeAction(TestAction action, TestContext context) {
        }

        @Override
        public void finish(TestContext context) {
        }

        @Override
        public void setTestResult(TestResult testResult) {
        }

        @Override
        public TestResult getTestResult() {
            return null;
        }

        @Override
        public void setIncremental(boolean incremental) {
        }

        @Override
        public void addFinalAction(TestActionBuilder<?> action) {
        }

        @Override
        public void setPackageName(String packageName) {
        }

        @Override
        public void setActiveAction(TestAction action) {
        }

        @Override
        public void setExecutedAction(TestAction action) {
        }

        @Override
        public void setTestClass(Class<?> type) {
        }

        @Override
        public TestCaseMetaInfo getMetaInfo() {
            return new TestCaseMetaInfo();
        }

        @Override
        public Class<?> getTestClass() {
            return this.getClass();
        }
    }
}

