/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.context.resolver;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.spi.ResourcePathTypeResolver;
import com.consol.citrus.spi.TypeResolver;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface TypeAliasResolver<S, A> {
    public static final Logger LOG = LoggerFactory.getLogger(TypeAliasResolver.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/context/resolver";
    public static final TypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/context/resolver");
    public static final Map<String, TypeAliasResolver<?, ?>> resolvers = new HashMap();

    public static Map<String, TypeAliasResolver<?, ?>> lookup() {
        if (resolvers.isEmpty()) {
            resolvers.putAll(TYPE_RESOLVER.resolveAll("", "type", "name"));
            if (LOG.isDebugEnabled()) {
                resolvers.forEach((k, v) -> LOG.debug(String.format("Found type alias resolver '%s' as %s", k, v.getClass())));
            }
        }
        return resolvers;
    }

    public static Optional<TypeAliasResolver<?, ?>> lookup(String resolver) {
        try {
            return Optional.of((TypeAliasResolver)TYPE_RESOLVER.resolve(resolver, new Object[0]));
        }
        catch (CitrusRuntimeException e) {
            LOG.warn(String.format("Failed to resolve type alias resolver from resource '%s/%s'", RESOURCE_PATH, resolver));
            return Optional.empty();
        }
    }

    public boolean isAliasFor(Class<?> var1);

    public S adapt(Object var1);

    public Class<A> getAliasType();
}

