/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.report;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.message.Message;
import com.consol.citrus.report.MessageListener;
import com.consol.citrus.report.MessageListenerAware;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class MessageListeners
implements MessageListenerAware {
    private final List<MessageListener> messageListener = new ArrayList<MessageListener>();

    public void onInboundMessage(Message message, TestContext context) {
        if (message != null) {
            for (MessageListener listener : this.messageListener) {
                listener.onInboundMessage(message, context);
            }
        }
    }

    public void onOutboundMessage(Message message, TestContext context) {
        if (message != null) {
            for (MessageListener listener : this.messageListener) {
                listener.onOutboundMessage(message, context);
            }
        }
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.messageListener);
    }

    @Override
    public void addMessageListener(MessageListener listener) {
        if (!this.messageListener.contains(listener)) {
            this.messageListener.add(listener);
        }
    }

    public List<MessageListener> getMessageListener() {
        return Collections.unmodifiableList(this.messageListener);
    }
}

