/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.variable;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class VariableExpressionSegmentMatcher {
    private static final Pattern VAR_PATH_PATTERN = Pattern.compile("(xpath\\((.*)\\)$)|(jsonPath\\((\\$[.\\[].*)\\)$)|(([^\\[\\].]+)(\\[([0-9])])?)(\\.|$)");
    private static final int XPATH_SEGMENT_GROUP = 1;
    private static final int XPATH_GROUP = 2;
    private static final int JSONPATH_SEGMENT_GROUP = 3;
    private static final int JSON_PATH_GROUP = 4;
    private static final int VAR_PROP_SEGMENT_GROUP = 5;
    private static final int VAR_PROP_NAME_GROUP = 6;
    private static final int NAME_INDEX_GROUP = 7;
    private static final int INDEX_GROUP = 8;
    private final String variableExpression;
    private final Matcher matcher;
    private final int totalSegmentCount;
    private String currentSegmentExpression;
    private int currentSegmentIndex = -1;

    public VariableExpressionSegmentMatcher(String variableExpression) {
        this.variableExpression = variableExpression;
        this.totalSegmentCount = this.totalSegmentCount(variableExpression);
        this.matcher = VAR_PATH_PATTERN.matcher(variableExpression);
    }

    private int totalSegmentCount(String variableExpression) {
        Matcher matcher = VAR_PATH_PATTERN.matcher(variableExpression);
        return (int)matcher.results().count();
    }

    public int getTotalSegmentCount() {
        return this.totalSegmentCount;
    }

    public boolean nextMatch() {
        boolean matches = this.matcher.find();
        this.currentSegmentExpression = null;
        this.currentSegmentIndex = -1;
        if (matches) {
            if (StringUtils.hasLength((String)this.matcher.group(4))) {
                this.currentSegmentExpression = this.matcher.group(4);
            } else if (StringUtils.hasLength((String)this.matcher.group(2))) {
                this.currentSegmentExpression = this.matcher.group(2);
            } else {
                this.currentSegmentExpression = this.matcher.group(6);
                this.currentSegmentIndex = this.matcher.group(8) != null ? Integer.parseInt(this.matcher.group(8)) : -1;
            }
        }
        return matches;
    }

    public String getVariableExpression() {
        return this.variableExpression;
    }

    public String getSegmentExpression() {
        return this.currentSegmentExpression;
    }

    public int getSegmentIndex() {
        return this.currentSegmentIndex;
    }
}

