/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus;

import com.consol.citrus.DefaultTestCase;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.TestActionRunner;
import com.consol.citrus.TestBehavior;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestCaseMetaInfo;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.TestGroupAware;
import com.consol.citrus.actions.ApplyTestBehaviorAction;
import com.consol.citrus.container.FinallySequence;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.spi.ReferenceResolverAware;
import java.util.Date;

public class DefaultTestCaseRunner
implements TestCaseRunner {
    private final TestCase testCase;
    private final TestContext context;

    public DefaultTestCaseRunner(TestContext context) {
        this(new DefaultTestCase(), context);
    }

    public DefaultTestCaseRunner(TestCase testCase, TestContext context) {
        this.testCase = testCase;
        this.context = context;
        this.testCase.setIncremental(true);
    }

    public void start() {
        this.testCase.start(this.context);
    }

    public void stop() {
        this.testCase.finish(this.context);
    }

    public <T> T variable(String name, T value) {
        this.testCase.getVariableDefinitions().put(name, value);
        if (value instanceof String) {
            String resolved = this.context.replaceDynamicContentInString(value.toString());
            this.context.setVariable(name, (Object)resolved);
            return (T)resolved;
        }
        this.context.setVariable(name, value);
        return value;
    }

    public void testClass(Class<?> type) {
        this.testCase.setTestClass(type);
    }

    public void name(String name) {
        this.testCase.setName(name);
    }

    public void description(String description) {
        this.testCase.setDescription(description);
    }

    public void author(String author) {
        this.testCase.getMetaInfo().setAuthor(author);
    }

    public void packageName(String packageName) {
        this.testCase.setPackageName(packageName);
    }

    public void status(TestCaseMetaInfo.Status status) {
        this.testCase.getMetaInfo().setStatus(status);
    }

    public void creationDate(Date date) {
        this.testCase.getMetaInfo().setCreationDate(date);
    }

    public void groups(String[] groups) {
        if (this.testCase instanceof TestGroupAware) {
            ((TestGroupAware)this.testCase).setGroups(groups);
        }
    }

    public <T extends TestAction> T run(TestActionBuilder<T> builder) {
        if (builder instanceof ReferenceResolverAware) {
            ((ReferenceResolverAware)builder).setReferenceResolver(this.context.getReferenceResolver());
        }
        if (builder instanceof ApplyTestBehaviorAction.Builder) {
            ((ApplyTestBehaviorAction.Builder)builder).on((TestActionRunner)this);
        }
        TestAction action = builder.build();
        if (builder instanceof FinallySequence.Builder) {
            ((FinallySequence.Builder)builder).getActions().forEach(arg_0 -> ((TestCase)this.testCase).addFinalAction(arg_0));
            return (T)action;
        }
        this.testCase.addTestAction(action);
        this.testCase.executeAction(action, this.context);
        return (T)action;
    }

    public ApplyTestBehaviorAction.Builder applyBehavior(TestBehavior behavior) {
        return new ApplyTestBehaviorAction.Builder().behavior(behavior).on((TestActionRunner)this);
    }

    public TestCase getTestCase() {
        return this.testCase;
    }
}

