/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.actions;

import com.consol.citrus.AbstractTestActionBuilder;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestActor;
import com.consol.citrus.TestActorAware;
import com.consol.citrus.common.Described;
import com.consol.citrus.common.Named;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.util.SqlUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class AbstractDatabaseConnectingTestAction
extends JdbcDaoSupport
implements TestAction,
Named,
Described,
TestActorAware {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String description;
    private String name;
    private TestActor actor;
    protected final String sqlResourcePath;
    protected final List<String> statements;
    private final PlatformTransactionManager transactionManager;
    private final String transactionTimeout;
    private final String transactionIsolationLevel;

    protected AbstractDatabaseConnectingTestAction(String name, Builder<?, ?> builder) {
        this.name = Optional.ofNullable(builder.getName()).orElse(name);
        this.description = builder.getDescription();
        this.actor = builder.getActor();
        Optional.ofNullable(builder.jdbcTemplate).ifPresent(x$0 -> super.setJdbcTemplate(x$0));
        Optional.ofNullable(builder.dataSource).ifPresent(x$0 -> super.setDataSource(x$0));
        this.sqlResourcePath = builder.sqlResourcePath;
        this.transactionIsolationLevel = builder.transactionIsolationLevel;
        this.transactionManager = builder.transactionManager;
        this.transactionTimeout = builder.transactionTimeout;
        this.statements = builder.statements;
    }

    public void execute(TestContext context) {
        this.doExecute(context);
    }

    public abstract void doExecute(TestContext var1);

    public boolean isDisabled(TestContext context) {
        if (this.actor != null) {
            return this.actor.isDisabled();
        }
        return false;
    }

    protected List<String> createStatementsFromFileResource(TestContext context) {
        return SqlUtils.createStatementsFromFileResource(new PathMatchingResourcePatternResolver().getResource(context.replaceDynamicContentInString(this.sqlResourcePath)));
    }

    protected List<String> createStatementsFromFileResource(TestContext context, SqlUtils.LastScriptLineDecorator lineDecorator) {
        return SqlUtils.createStatementsFromFileResource(new PathMatchingResourcePatternResolver().getResource(context.replaceDynamicContentInString(this.sqlResourcePath)), lineDecorator);
    }

    public String getDescription() {
        return this.description;
    }

    public AbstractDatabaseConnectingTestAction setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSqlResourcePath() {
        return this.sqlResourcePath;
    }

    public List<String> getStatements() {
        return this.statements;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public String getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public String getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    public TestActor getActor() {
        return this.actor;
    }

    public AbstractDatabaseConnectingTestAction setActor(TestActor actor) {
        this.actor = actor;
        return this;
    }

    public static abstract class Builder<T extends AbstractDatabaseConnectingTestAction, S extends Builder<T, S>>
    extends AbstractTestActionBuilder<T, S> {
        protected JdbcTemplate jdbcTemplate;
        protected DataSource dataSource;
        protected String sqlResourcePath;
        protected List<String> statements = new ArrayList<String>();
        protected PlatformTransactionManager transactionManager;
        protected String transactionTimeout = String.valueOf(-1);
        protected String transactionIsolationLevel = "ISOLATION_DEFAULT";

        public S jdbcTemplate(JdbcTemplate jdbcTemplate) {
            this.jdbcTemplate = jdbcTemplate;
            return (S)((Builder)this.self);
        }

        public S transactionManager(PlatformTransactionManager transactionManager) {
            this.transactionManager = transactionManager;
            return (S)((Builder)this.self);
        }

        public S transactionTimeout(int transactionTimeout) {
            this.transactionTimeout = String.valueOf(transactionTimeout);
            return (S)((Builder)this.self);
        }

        public S transactionTimeout(String transactionTimeout) {
            this.transactionTimeout = transactionTimeout;
            return (S)((Builder)this.self);
        }

        public S transactionIsolationLevel(String isolationLevel) {
            this.transactionIsolationLevel = isolationLevel;
            return (S)((Builder)this.self);
        }

        public S dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return (S)((Builder)this.self);
        }

        public S statements(List<String> statements) {
            this.statements.addAll(statements);
            return (S)((Builder)this.self);
        }

        public S statement(String sql) {
            this.statements.add(sql);
            return (S)((Builder)this.self);
        }

        public S sqlResource(Resource sqlResource) {
            this.statements(SqlUtils.createStatementsFromFileResource(sqlResource));
            return (S)((Builder)this.self);
        }

        public S sqlResource(String filePath) {
            this.sqlResourcePath = filePath;
            return (S)((Builder)this.self);
        }
    }
}

